% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{or_monitors_500}
\alias{or_monitors_500}
\title{Oregon monitor locations dataset}
\format{
A tibble with 40 rows and 13 columns of data.
}
\usage{
or_monitors_500
}
\description{
The \code{or_monitor_500} dataset provides a set of known
locations associated with Oregon state air quality monitors.
This dataset was generatedon 2019-10-21 by running:

\preformatted{
library(PWFSLSmoke)
library(MazamaLocationUtils)

mazama_initialize()
setLocationDataDir("./data")

monitor <- monitor_loadLatest() %>% monitor_subset(stateCodes = "OR")
lons <- monitor$meta$longitude
lats <- monitor$meta$latitude

table_initialize() %>%
  table_addLocation(lons, lats, distanceThreshold = 500) %>%
  table_save("or_monitors_500")
}
}
\seealso{
\link{id_monitors_500}

\link{wa_monitors_500}
}
\keyword{datasets}
