% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_save.R
\name{table_save}
\alias{table_save}
\title{Save a known location table}
\usage{
table_save(
  locationTbl = NULL,
  collectionName = NULL,
  backup = TRUE,
  outputType = "rda"
)
}
\arguments{
\item{locationTbl}{Tibble of known locations, Default: NULL}

\item{collectionName}{Character identifier for this table, Default: NULL}

\item{backup}{Logical specifying whether to save a backup version of any
existing tables sharing \code{collectionName}.}

\item{outputType}{Output format, Default: 'rda'}
}
\value{
File path of saved file.
}
\description{
Save a tibble of known locations to the preferred directory.
}
\details{
Backup files are saved with "YYYY-mm-ddTHH:MM:SS"
}
\examples{
library(MazamaLocationUtils)

# Set the directory for saving location tables
setLocationDataDir(tempdir())

# Load an example table and check the dimensions
locationTbl <- get(data("wa_monitors_500"))
dim(locationTbl)

# Save it as "table_save_example"
table_save(locationTbl, "table_save_example")

# Add a column and save again
locationTbl \%>\% 
  table_addColumn("my_column") \%>\% 
  table_save(locationTbl, "table_save_example")
  
# Check the locationDataDir
list.files(getLocationDataDir(), pattern = "table_save_example")
}
