% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with.mimids.R
\name{with.mimids}
\alias{with.mimids}
\title{Evaluates an Expression in Matched Imputed Datasets}
\usage{
\method{with}{mimids}(data, expr, ...)
}
\arguments{
\item{data}{This argument specifies an object of the \code{mimids} class, typically produced by a previous call to the function \code{matchitmice()}.}

\item{expr}{This argument specifies an expression of the usual syntax of R formula. See \code{help(formula)} for details.}

\item{...}{Additional arguments to be passed to \code{expr}.}
}
\value{
This function returns an object of the \code{mira} class (multiply imputed repeated analyses).
}
\description{
The \code{with()} function performs a computation on each of the \code{n} imputed datasets. The typical sequence of steps to do a matching procedure on the imputed datasets are:
\enumerate{
 \item Impute the missing data points by the \code{mice} function (from the \pkg{mice} package), resulting in a multiple imputed dataset (an object of the \code{mids} class);
 \item Match each imputed dataset using a matching model by the \code{matchitmice()} function, resulting in an object of the \code{mimids} class;
 \item Fit the model of interest (scientific model) on each matched dataset by the \code{with()} function, resulting in an object of the \code{mira} class;
 \item Pool the estimates from each model into a single set of estimates and standard errors, resulting in an object of the \code{mipo} class.
}
}
\details{
The \code{with()} performs a computation on each of the imputed datasets.
}
\examples{
\donttest{
#Please see the package repository <https://github.com/FarhadPishgar/MatchIt.mice> for details.

#Loading the 'handoa' dataset
data(handoa)

#Imputing the missing data points in the 'handoa' dataset
datasets <- mice(handoa, m = 5, maxit = 1,
                 method = c("", "", "", "mean", "polyreg", "logreg", "", ""))

#Matching the imputed datasets, 'datasets'
matcheddatasets <- matchitmice(HANDOA ~ SEX + AGE, datasets)

#Analyzing the imputed datasets
results <- with(data = matcheddatasets,
                exp = glm(HANDOA ~ SMOKING,
                          na.action = na.omit, family = binomial))
}
}
\references{
Stef van Buuren and Karin Groothuis-Oudshoorn (2011). \code{mice}: Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of Statistical Software}, 45(3): 1-67. \url{https://www.jstatsoft.org/v45/i03/}
}
\seealso{
\code{\link[=matchitmice]{matchitmice}}
}
\author{
Extracted from the \pkg{mice} package written by Stef van Buuren et al. with few changes
}
\keyword{functions}
