% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.MLModelFit}
\alias{predict,MLModelFit-method}
\title{Model Prediction}
\usage{
\method{predict}{MLModelFit}(
  object,
  newdata = NULL,
  times = numeric(),
  type = c("response", "default", "numeric", "prob"),
  cutoff = MachineShop::settings("cutoff"),
  distr = character(),
  method = character(),
  verbose = FALSE,
  ...
)

\S4method{predict}{MLModelFit}(object, ...)
}
\arguments{
\item{object}{model \link{fit} result.}

\item{newdata}{optional \link[=data.frame]{data frame} with which to obtain
predictions.  If not specified, the training data will be used by default.}

\item{times}{numeric vector of follow-up times at which to predict
survival events/probabilities or \code{NULL} for predicted survival means.}

\item{type}{specifies prediction on the original outcome (\code{"response"}),
numeric (\code{"numeric"}), or probability (\code{"prob"}) scale; or
model-specific default predictions (\code{"default"}).}

\item{cutoff}{numeric (0, 1) threshold above which binary factor
probabilities are classified as events and below which survival
probabilities are classified.}

\item{distr}{character string specifying distributional approximations to
estimated survival curves.  Possible values are \code{"empirical"},
\code{"exponential"}, \code{"rayleigh"}, or \code{"weibull"}; with defaults
of \code{"empirical"} for predicted survival events/probabilities and
\code{"weibull"} for predicted survival means.}

\item{method}{character string specifying the empirical method of estimating
baseline survival curves for Cox proportional hazards-based models.
Choices are \code{"breslow"} or \code{"efron"} (default).}

\item{verbose}{logical indicating whether to display printed output generated
by some model-specific predict functions to aid in monitoring progress and
diagnosing errors.}

\item{...}{arguments passed from the S4 to the S3 method.}
}
\description{
Predict outcomes with a fitted model.
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm to run

## Survival response example
library(survival)

gbm_fit <- fit(Surv(time, status) ~ ., data = veteran, model = GBMModel)
predict(gbm_fit, newdata = veteran, times = c(90, 180, 360), type = "prob")
}

}
\seealso{
\code{\link{confusion}}, \code{\link{performance}},
\code{\link{metrics}}
}
