% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdev.R
\name{tdev}
\alias{tdev}
\title{Territorial Deviation}
\usage{
tdev(x, var1, var2, type = "rel", key)
}
\arguments{
\item{x}{a dataframe or a sf object including  var1 and var2 and an 
aggregation key field (territorial belonging).}

\item{var1}{name of the numerator variable in x.}

\item{var2}{name of the denominator variable in x.}

\item{type}{type of deviation; "rel" for relative deviation, "abs" for 
absolute deviation (see Details).}

\item{key}{aggregation key field for measuring the deviation (intermediate 
territorial level).}
}
\value{
A vector is returned.
}
\description{
Compute the deviation of each territorial unit as regards  
to an intermediate territorial level of reference.
}
\details{
The relative territorial deviation is the ratio between var1/var2 and 
var1/var2 at the aggregated level. Values greater than 100 indicate that the 
unit ratio is greater than the ratio at the aggregated level. Values lower 
than 100 indicate that the unit ratio is lower than the ratio of the 
aggregated level.\cr
The absolute territorial deviation is the amount of numerator that could be 
moved to obtain the ratio of the aggregated level on all belonging units.
}
\examples{
# Load data
library(sf)
com <- st_read(system.file("metroparis.gpkg", package = "MTA"), layer = "com", quiet = TRUE)
ept <- st_read(system.file("metroparis.gpkg", package = "MTA"), layer = "ept", quiet = TRUE)

# compute absolute territorial deviation
com$tdevabs <- tdev(x = com, var1 = "INC", var2 = "TH", key = "EPT", 
                    type = "abs")
# compute relative territorial deviation
com$tdevrel <- tdev(x = com, var1 = "INC", var2 = "TH", key = "EPT", 
                    type = "rel")
if(require(mapsf)){
# relative deviation map
# set breaks
bks <- c(min(com$tdevrel), 80, 91, 100, 110, 125, max(com$tdevrel))
# plot a choropleth map of the relative territorial deviation
mf_map(x = com, var = "tdevrel", type = "choro", leg_pos = "topleft",
       leg_title = "Relative Deviation\n(100 = general average)",
       breaks = bks, border = NA,
       pal = c("#4575B4", "#91BFDB", "#E0F3F8", "#FEE090", "#FC8D59", "#D73027"))

# add EPT boundaries
mf_map(x = ept, col = NA, add = TRUE)

# layout
mf_layout(title = "Territorial Deviation (reference: EPT of belonging)",
         credits = paste0("Sources: GEOFLA® 2015 v2.1, Apur, impots.gouv.fr",
                          "\nMTA", packageVersion("MTA")),
         arrow = FALSE)


# absolute deviation map
com$sign <- ifelse(test = com$tdevabs < 0, yes = "Under-Income", no = "Over-Income")
mf_map(ept)

mf_map(x = com, var = c("tdevabs", "sign"), type = "prop_typo", inches = 0.2,
      leg_title = c("Absolute Deviation\n(Income redistribution, euros)",
                    "Redistribution direction"), 
      leg_pos = c("topleft", "topright"), leg_val_rnd = -2,
      val_order = c("Under-Income", "Over-Income"),
      pal =  c("#ff0000","#0000ff"), add = TRUE)

# layout
mf_layout(title = "Territorial Deviation (reference: EPT of belonging)",
         credits = paste0("Sources: GEOFLA® 2015 v2.1, Apur, impots.gouv.fr",
                          "\nMTA", packageVersion("MTA")),
         arrow = FALSE)
}
}
