% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ARmdl}
\alias{ARmdl}
\title{Autoregressive Model}
\usage{
ARmdl(Y, p, control = list())
}
\arguments{
\item{Y}{A \code{(T x 1)} matrix of observations.}

\item{p}{Integer determining the number of autoregressive lags.}

\item{control}{List with model options including: 
\itemize{
  \item{\code{const}: }{Boolean determining whether to estimate model with constant if \code{TRUE} or not if \code{FALSE}. Default is \code{TRUE}.}
  \item{\code{getSE}: }{Boolean determining whether to compute standard errors of parameters if \code{TRUE} or not if \code{FALSE}. Default is \code{TRUE}.}
}}
}
\value{
List of class \code{ARmdl} (\code{S3} object) with model attributes including:
\itemize{
  \item{\code{y}: }{a \code{(T-p x 1)} matrix of observations.}
  \item{\code{X}: }{a \code{(T-p x p + const)} matrix of lagged observations with a leading column of \code{1}s if \code{const=TRUE} or not if \code{const=FALSE}.}
  \item{\code{x}: }{a \code{(T-p x p)} matrix of lagged observations.}
  \item{\code{resid}: }{a \code{(T-p x 1)} matrix of residuals.}
  \item{\code{mu}: }{estimated mean of the process.}
  \item{\code{coef}: }{coefficient estimates. First value is the intercept (i.e., not \code{mu}) if \code{const=TRUE}. This is the same as \code{phi} if \code{const=FALSE}.}
  \item{\code{intercept}: }{estimate of intercept.}
  \item{\code{phi}: }{estimates of autoregressive coefficients.}
  \item{\code{stdev}: }{estimated standard deviation of the process.}
  \item{\code{sigma}: }{estimated variance of the process.}
  \item{\code{theta}: }{vector containing: \code{mu}, \code{sigma}, and \code{phi}.}
  \item{\code{theta_mu_ind}: }{vector indicating location of mean with \code{1} and \code{0} otherwise.}
  \item{\code{theta_sig_ind}: }{vector indicating location of variance with \code{1} and \code{0} otherwise.}
  \item{\code{theta_var_ind}: }{vector indicating location of variance with \code{1} and \code{0} otherwise. This is the same as \code{theta_sig_ind} in \code{ARmdl}.}
  \item{\code{theta_phi_ind}: }{vector indicating location of autoregressive coefficients with \code{1} and \code{0} otherwise.}
  \item{\code{stationary}: }{Boolean indicating if process is stationary if \code{TRUE} or non-stationary if \code{FALSE}.}
  \item{\code{n}: }{number of observations after lag transformation (i.e., \code{n = T-p}).}
  \item{\code{p}: }{number of autoregressive lags.}
  \item{\code{q}: }{number of series. This is always \code{1} in \code{ARmdl}.}
  \item{\code{k}: }{number of regimes. This is always \code{1} in \code{ARmdl}.}
  \item{\code{control}: }{List with model options used.}
  \item{\code{logLike}: }{log-likelihood.}
  \item{\code{AIC}: }{Akaike information criterion.}
  \item{\code{BIC}: }{Bayesian (Schwarz) information criterion.}
  \item{\code{Hess}: }{Hessian matrix. Approximated using \code{\link[numDeriv]{hessian}} and only returned if \code{getSE=TRUE}.}
  \item{\code{info_mat}: }{Information matrix. Computed as the inverse of \code{-Hess}. If matrix is not PD then nearest PD matrix is obtained using \code{\link[lmf]{nearPD}}. Only returned if \code{getSE=TRUE}.}
  \item{\code{nearPD_used}: }{Boolean determining whether \code{nearPD} function was used on \code{info_mat} if \code{TRUE} or not if \code{FALSE}. Only returned if \code{getSE=TRUE}.}
  \item{\code{theta_se}: }{standard errors of parameters in \code{theta}.  Only returned if \code{getSE=TRUE}.}
}
}
\description{
This function estimates an autoregresive model with \code{p} lags. This can be used for the null hypothesis of a linear model against an alternative hypothesis of a Markov switching autoregressive model with \code{k} regimes.
}
\examples{
set.seed(1234)
# Define DGP of AR process
mdl_ar <- list(n     = 500, 
               mu    = 5,
               sigma = 2,
               phi   = c(0.5,0.2))

# Simulate process using simuAR() function
y_simu <- simuAR(mdl_ar)

# Set options for model estimation
control <- list(const  = TRUE, 
                getSE  = TRUE)

# Estimate model
y_ar_mdl <- ARmdl(y_simu$y, p = 2, control)

y_ar_mdl
}
\seealso{
\code{\link{MSARmdl}}
}
