% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculatePower.R
\name{calculatePower}
\alias{calculatePower}
\title{Calculate power for micro-randomized trials}
\usage{
calculatePower(days, occ_per_day, prob, beta_shape, beta_mean, beta_initial,
  beta_quadratic_max, tau_shape, tau_mean, tau_initial, tau_quadratic_max,
  sample_size, sigLev)
}
\arguments{
\item{days}{Duration of the study.}

\item{occ_per_day}{Number of decision time points per day.}

\item{prob}{Randomization probability, i.e. the probability of assigning the treatment at a decision time
point. This can be constant, or time-varying probabilities can be specified by a vector
specifying randomization probabilities for each day or decision time.}

\item{beta_shape}{The trend for the proximal treatment effect, choices are constant, linear or quadratic.
Note:
 \enumerate{
             \item{Constant} The proximal treatment effect stays constant over the study.
             \item{Linear} The linearly increasing form of a proximal treatment effect might be
             used if participants will get more enthusiastically engage in the apps and thus
             the proximal effect will increase as the study goes. The linearly decreasing form
             of a proximal treatment effect might be used if participants are likely to disengage
             the activity suggestionss and thus the proximal effect will decrease as the study goes.
             \item{Quadratic}  The quadratic form of a proximal treatment effect might be used if
             you expect that initially participants will enthusiastically engage in the apps and
             thus the proximal effect will get higher. Then, as the study goes on, some participants
             are likely to disengage or begin to ignore the activity suggestions and hence a downward
             trend.
 }}

\item{beta_mean}{Average of proximal treatment effect.}

\item{beta_initial}{Initial value of proximal treatment effect when beta_shape is linear or quadratic.}

\item{beta_quadratic_max}{Day of maximal proximal treatment effect when beta_shape is quadratic.}

\item{tau_shape}{The pattern for expected availability, choices are constant, linear or quadratic.
Note:
 \enumerate{
             \item{Constant} The expected availability stays constant over the study.
             \item{Linear} A linearly increasing pattern of expected availability might be used if
             participants will find the intervention useful and thus more likely to turn the
             intervention on. A linearly decreasing pattern of expected availability might be used
             if participants learn more about the intervetion and get bored through the course of
             the study and thus getting less likely to turn on the invervention.
             \item{Quadratic} A quadratic pattern of availability. Here the changing point of
             availability refers to day of either maximal of minimal availability, depending on the
             input values of initial and average availability.
 }}

\item{tau_mean}{Average of expected availability.}

\item{tau_initial}{Initial Value of expected availability when tau_shape is linear or quadratic.}

\item{tau_quadratic_max}{Changing point of availability when tau_shape is quadratic.}

\item{sample_size}{Number of participants}

\item{sigLev}{Significance level}
}
\value{
power.
}
\description{
This function calculates power for micro-randomized trials (MRTs)
based on methodology developed in Sample Size Calculations for Micro-randomized Trials in
mHealth by Liao et al. (2016) <DOI:10.1002/sim.6847>.
}
\examples{
    calculatePower(days=42,
                   occ_per_day=5,
                   prob=0.4,
                   beta_shape="quadratic",
                   beta_mean=0.1,
                   beta_initial=0,
                   beta_quadratic_max=28,
                   tau_shape="quadratic",
                   tau_mean=0.5,
                   tau_initial=0.7,
                   tau_quadratic_max=42,
                   sample_size=40,
                   sigLev=0.05)

    prob1 <- c(replicate(35,0.7),replicate(35,0.6),replicate(35,0.5),replicate(35,0.4))
    calculatePower(days=28,
                   occ_per_day=5,
                   prob=prob1,
                   beta_shape="quadratic",
                   beta_mean=0.1,
                   beta_initial=0,
                   beta_quadratic_max=28,
                   tau_shape="quadratic",
                   tau_mean=0.5,
                   tau_initial=0.7,
                   tau_quadratic_max=42,
                   sample_size=40,
                   sigLev=0.05)#'

}
\references{
Seewald, N.J.; Sun, J.; Liao, P. "MRT-SS Calculator: An R Shiny Application for Sample Size
Calculation in Micro-Randomized Trials". arXiv:1609.00695
}

