test_that("calculate_mrt_effect_size works without bootstrap and returns expected structure", {
  data("data_example_for_standardized_effect", package = "MRTAnalysis")
  dat <- data_example_for_standardized_effect
  T <- length(unique(dat$decision_point))

  ans <- calculate_mrt_effect_size(
    data         = dat,
    id           = "id",
    outcome      = "outcome",
    treatment    = "treatment",
    time         = "decision_point",
    rand_prob    = "prob_treatment",
    availability = "availability",
    covariates   = c("covariate1", "covariate2"),
    do_bootstrap = FALSE
  )

  expect_s3_class(ans, "data.frame")
  expect_s3_class(ans, "mrt_effect_size")
  expect_true(all(c("time", "estimate") %in% names(ans)))
  expect_equal(nrow(ans), T)
  expect_equal(ans$time, sort(unique(dat$decision_point)))
  expect_true(is.numeric(ans$estimate))

  s <- summary(ans)
  expect_s3_class(s, "summary.mrt_effect_size")
  expect_true(is.data.frame(s$effect_summary))
  expect_silent(plot(ans))
})

test_that("calculate_mrt_effect_size errors when required column names are missing", {
  data("data_example_for_standardized_effect", package = "MRTAnalysis")
  dat <- data_example_for_standardized_effect

  expect_error(
    calculate_mrt_effect_size(
      data         = dat,
      id           = "id",
      outcome      = "outcome",
      treatment    = "treatment",
      time         = "decision_point",
      rand_prob    = NULL,
      availability = "availability",
      do_bootstrap = FALSE
    )
  )

  expect_error(
    calculate_mrt_effect_size(
      data         = dat,
      id           = "id",
      outcome      = "outcome",
      treatment    = "treatment",
      time         = "decision_point",
      rand_prob    = "prob_treatment",
      availability = NULL,
      do_bootstrap = FALSE
    )
  )
})
