\name{constLatex}
\title{Constructor for Latex report}
\alias{constLatex}
\description{
Construct a Latex report that includes plots generated by the \code{\link{multiplot}} function.
}
\usage{
constLatex(dir,filename=NULL,identifier=NULL,param=NULL,table=NULL,extra_text=NULL,
         subsection=NULL,label=NULL,
         width=0.9,trim=c(0,0,0,0),plotPerPage=3,
         width.legend=0.35,trim.legend=c(0,0,0,0),
         title="",date="",author="",trace=TRUE)
}
\arguments{
  \item{dir}{the path to the root directory. This directory should contains subsdirectories themself containing the image files. \emph{character}.}
  \item{filename}{the name of the latex file that should be generated. \emph{character} or \emph{NULL}.}
  
  \item{identifier}{the identifiers of the patients for which the graphics should be displayed. \emph{character vector} or \code{NULL} leading to use all patients.}
  \item{param}{the names of subdirectories containing the images. \emph{character vector} or \code{NULL} leading to use all subdirectories.}
  \item{table}{a list of data.frame to display in the table format. \emph{list of data.frame} or \code{NULL} if there is no table to display.}
  \item{extra_text}{additionnal text to display. \emph{list of character vector} or \code{NULL} if there is no extra text to display.}
    
  \item{subsection}{the names of subsections for the latex document. \emph{character vector} or \code{NULL} leading to use \code{param} for naming the subsections.}
  \item{label}{the legend that will be displayed under each figure of a given parameter. \emph{character vector} or \code{NULL} leading to use \code{param} for the legend.}
  
  \item{trace}{should the execution of the function be traced ? \emph{logical}.}
  \item{width}{the width of each image relative to the linewidth. \emph{positive numeric}.}
  \item{trim}{the length in mm with which the imported images will be cropped (left, bottom, right top). \emph{numeric vector of size 4}.}
  \item{plotPerPage}{the number of image that should be displayed on the same page. \emph{strictly positive interger}.}
    
  \item{width.legend}{the width of the legend image relative to the linewidth. \emph{numeric between 0 and 1}.}
  \item{trim.legend}{the length in mm with which the legend of the images will be cropped. \emph{numeric vector of size 4}.}
    
  \item{title}{the title of the latex document. \emph{character}.}
  \item{date}{the date on the latex document. \emph{character}.}
  \item{author}{the author of the latex document. \emph{character}.}
}
\details{
ARGUMENTS: \cr
\code{table} must contains in its first column the patient identifiers. This column will not be display.

FUNCTION: \cr
Patient identifiers are read from the file names : it is the character string preceding the first underscore (\code{"_"}). 

The function generate latex code that reads the images using the \code{includegraphicx} latex function. 
In particular arguments \code{width}, \code{trim}, \code{width.legend} and \code{trim.legend} are used by this function to adjust the display of the images.

The latex files require the following (latex) packages to compile: inputenc, amssymb, amsmath, titlesec, geometry, enumitem, graphicx, color, space, hyperref and caption.
If \code{filename} is set to \code{NULL} the latex file will not be created.
}
\value{
  A \emph{list} containing :
  \itemize{
  \item\code{[[text.preamble]]} : a \emph{character} containing the preamble of a latex document.
  \item\code{[[text.begin]]} : a \emph{character} for beginning the latex report.
  \item\code{[[ls.text]]} : a \emph{list of character}, each containing the content of the report for each patient.
  \item\code{[[text.end]]} :  a \emph{character} for ending the latex report.
  }
}

\examples{
\dontrun{
## generate MRIaggr objects
data("MRIaggr.Pat1_red", package="MRIaggr")

path.Pat2 <- system.file("anlz", package="oro.nifti")
analyse.avg <- readMRI(file.path(path.Pat2,"avg152T1"),format="analyze")
# analyse.avg@descrip
MRIaggr.Pat2 <- constMRIaggr(analyse.avg,param="T1_t0",identifier="Pat2")

path.Pat3 <- system.file("nifti", package="oro.nifti")
nifti.ffd <- readMRI(file.path(path.Pat3,"filtered_func_data"),format="nifti")
# nifti.ffd@descrip
MRIaggr.Pat3 <- constMRIaggr(lapply(1:5,function(x){nifti.ffd[,,,x,drop=FALSE]}),
                             param=paste("T2_GRE_t",0:4,sep=""),identifier="Pat3")

## create directories			
path <- "."
dir.create(file.path(path,"Display"))
dir.create(file.path(path,"Display/T1_t0"))
dir.create(file.path(path,"Display/T2_GRE_t0"))
dir.create(file.path(path,"Display/MASK_DWI_t0"))

## export images 
multiplot(MRIaggr.Pat1_red,param="T1_t0",
          mfrow=c(2,4),axes=FALSE,mar=c(0,0,1.5,0),
          window="png",path="Display/T1_t0/")
multiplot(MRIaggr.Pat2,param="T1_t0",
          mfrow=c(3,6),axes=FALSE,mar=c(0,0,1.5,0),legend=FALSE,
          window="png",path="Display/T1_t0/")

multiplot(MRIaggr.Pat1_red,param="T2_GRE_t0",
          mfrow=c(2,4),axes=FALSE,mar=c(0,0,1.5,0),
          window="png",path="Display/T2_GRE_t0/")
multiplot(MRIaggr.Pat3,param="T2_GRE_t0",
          mfrow=c(2,4),axes=FALSE,mar=c(0,0,1.5,0),
          window="png",path="Display/T2_GRE_t0/")

multiplot(MRIaggr.Pat1_red,param="MASK_DWI_t0",
          mfrow=c(2,4),axes=FALSE,mar=c(0,0,1.5,0),
          window="png",path="Display/MASK_DWI_t0/")

## create latex file (default)
res <- constLatex(dir="Display",file="sweaveDisplay")

## create latex file (personalized)
res <- constLatex(dir="Display",file="sweaveDisplay",
                  param=c("T1_t0","T2_GRE_t0","MASK_DWI_t0"),
                  table=list(data.frame(cbind(Id=c("Pat1","Pat2","Pat3"),
                                               Age=c(28,54,32),
                                               Gender=c("Male","Female","Male")))
                              ),
                   label=c("T1 sequence","T2 gradient echo sequence","lesion mask"),
                   extra_text=list("Patient 1 suffers from stroke diseases ...",
                                   "Patient 2 has ...",
                                   "Patient 3 has ...")
)
}
}
\concept{const.}
\keyword{functions,Sweave}

