% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vs_mram.R
\name{vs_mram}
\alias{vs_mram}
\title{Variable Selection via the Multivariate Regression Association Measure}
\usage{
vs_mram(y_data, x_data)
}
\arguments{
\item{y_data}{A \eqn{n \times d} matrix of responses.}

\item{x_data}{A \eqn{n \times p} matrix of predictors.}
}
\value{
The vector containing the indices of the selected predictors in the order they were chosen.
}
\description{
Perform variable selection via the multivariate regression association measure proposed in Shih and Chen (2025).
}
\details{
\code{vs_mram} is a forward and stepwise variable selection algorithm which utilizes the multivariate regression association measure proposed in Shih and Chen (2025). The Algorithm is modified from the feature ordering by conditional independence (FOCI) algorithm from Azadkia and Chatterjee (2021).
}
\examples{
n = 200
p = 10

x_data = matrix(rnorm(p*n),n,p)
y_data = x_data[,1]*x_data[,2]+x_data[,1]-x_data[,3]+rnorm(n)
colnames(x_data) = paste0(rep("X",p),seq(1,p))

library(MRAM)
mram_res = vs_mram(y_data,x_data)
}
\references{
Azadkia and Chatterjee (2021) A simple measure of conditional dependence, Annals of Statistics, 46(6): 3070-3102.

Shih and Chen (2025) Measuring multivariate regression association via spatial sign (in revision, Computational Statistics & Data Analysis)
}
\seealso{
\code{\link{mram}}
}
