% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.r
\docType{data}
\name{twoindex}
\alias{twoindex}
\title{twoindex has orange roughy catches with hypothetical cpue}
\format{A data.frame of fishery data 
\describe{
  \item{year}{the calander year of fishing}
  \item{catch}{the reported catch in tonnes}
  \item{cpue1}{the first index of relative abundance}
  \item{cpue2}{the second index of relative abundance}
}}
\source{
Catches extracted from Table 4, page 11 of Haddon, M. (2017) 
   Orange Roughy East (Hoplostethus atlanticus) stock assessment
   using data to 2016 Report to November 2017 SE RAG meeting. CSIRO, 
   Oceans and Atmosphere, Australia. 51p. from 
   https://www.afma.gov.au/fisheries-management/species/orange-roughy 
   Catch data extended to 2019 using AFMA's catchwatch system.
}
\description{
twoindex is a 35 x 4 data.frame of fishery data made 
    up of smoothed real catches but two simulated indices of relative
    abundance. This data-set is designed to be used to illustrate
    the implementation of surplus production models when there are
    more than one time-series of relative abundance indices. The
    indices have been designed to generate a workable answer but also
    require the use of a penalty on harvest rates to avoid massively 
    inflated harvest rates well above 1. Instead of using simpspm,
    spm, and negLL1, we need to use simpspmM, spmCE, and negLLM.
    The cpue series are hypothetical and have been designed to 
    illustrate the use of penalty1 and the use of multiple indices 
    of relative abundance. The real stock assessment uses acoustic 
    survey indices and also uses many years of age composition data 
    inside Stock Synthesis 3, not surprisingly the inclusion of real
    time-series of indices and of age-composition data leads to very 
    different results.
}
\section{Subjects}{

 \itemize{
   \item Surplus production models
   \item Dynamic model fitting
   \item -ve log-likelihoods
 }
}

\examples{
 data(twoindex)
 fish <- as.matrix(twoindex)
 pars <- log(c(0.04,155000,0.4,0.3))
 bestSP <- nlm(f=negLLM,p=pars,funk=simpspmM,indat=fish,
             schaefer=TRUE,logobs=log(fish[,c("cpue1","cpue2")]),
             steptol=1e-06,harvpen=TRUE)
 namepar <- c("r", "K", "Binit","sigma")
 outfit(bestSP,parnames=namepar)  # best fitting estimates
 # if 'Either ~local min or steptol too small try 'steptol=1e-05'
 # plotprep(width=7,height=5,newdev=FALSE) # for external plot
 answer <- plotspmmod(bestSP$estimate,indat=fish,
                      plotprod=TRUE,maxy=3.4)
}
