% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_maxeval.R
\name{stop_maxeval}
\alias{stop_maxeval}
\title{Stop criterion: maximum number of evaluations}
\usage{
stop_maxeval(stopcrit, nfe, ...)
}
\arguments{
\item{stopcrit}{list containing the parameters defining the stop
handling method. See Section \verb{Constraint Handling} of the \code{\link[=moead]{moead()}}
documentation for details.}

\item{nfe}{evaluations counter of \code{\link[=moead]{moead()}}.}

\item{...}{other parameters (included for compatibility with generic call)}
}
\value{
boolean value: \code{TRUE} if this criterion has been met, \code{FALSE}
otherwise.
}
\description{
Verifies stop criterion "maximum number of evaluations" for the MOEADr
package. For internal use only, not to be called directly by the user.
}
\details{
When this stop criterion is used, one element of the \code{stopcrit}
parameter (see \code{\link[=moead]{moead()}}) must have the following structure:
\itemize{
\item \code{stopcrit$name = "maxeval"}
\item \code{stopcrit$maxeval}, containing a positive integer representing the
desired maximum number of evaluations.
}
}
\section{References}{

F. Campelo, L.S. Batista, C. Aranha (2020): The {MOEADr} Package: A
Component-Based Framework for Multiobjective Evolutionary Algorithms Based on
Decomposition. Journal of Statistical Software \doi{10.18637/jss.v092.i06}\cr
}

