% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomposition_sld.R
\name{decomposition_sld}
\alias{decomposition_sld}
\title{Problem Decomposition using Simplex-lattice Design}
\usage{
decomposition_sld(decomp, ...)
}
\arguments{
\item{decomp}{list containing the relevant decomposition parameters.
Besides \code{decomp$name = "sld"}, this method requires the definition of the
following key-value pairs:
\itemize{
\item \code{decomp$H}, decomposition constant. Suggested values for \code{decomp$H}
are (use with caution):
\tabular{ccccc}{
\code{m}\tab |\tab\code{H}\tab |\tab\code{N}\cr
\code{2}    \tab  |\tab\code{99}      \tab |\tab\code{100}\cr
\code{3}    \tab  |\tab\code{12}      \tab |\tab\code{91}\cr
\code{5}    \tab  |\tab\code{6}       \tab |\tab\code{210}\cr
}
It is important to highlight that the number of vectors generated (\code{N}) must
be greater than the number of neighbors declared in \code{neighbors$T}
(see \code{\link[=moead]{moead()}} for details).
\item \code{decomp$.nobj}: integer value, \code{decomp$.nobj > 1}. Number of
objectives of the problem.
}}

\item{...}{other parameters (included for compatibility with generic call)}
}
\description{
Problem Decomposition using Simplex-lattice Design for MOEADr package
}
\details{
This routine calculates the weight vectors for the MOEA/D using the
Simplex-lattice Design.
}
\section{References}{

I. Das, J. Dennis (1998), "Normal Boundary Intersection - A New Method
for Generating the Pareto Surface in Nonlinear Multicriteria Optimization
Problems", SIAM J. Optim., 8(3), 631-657. DOI: 10.1137/S1052623496307510
}

