% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_projection.R
\name{check_projection}
\alias{check_projection}
\alias{check_projection.default}
\alias{check_projection.numeric}
\alias{check_projection.character}
\alias{check_projection.crs}
\title{Check the validity of the input projection}
\usage{
check_projection(projection, abort = FALSE, verbose = TRUE)

\method{check_projection}{default}(projection, abort = FALSE, verbose = TRUE)

\method{check_projection}{numeric}(projection, abort = FALSE, verbose = TRUE)

\method{check_projection}{character}(projection, abort = FALSE, verbose = TRUE)

\method{check_projection}{crs}(projection, abort = FALSE, verbose = TRUE)
}
\arguments{
\item{projection}{\code{character} or \code{integer} corresponding to the
an EPSG code, a UTM zone (e.g. "32N") or a WKT representation of  a projection;}

\item{abort}{\code{logical} if TRUE, the function aborts in case an invalid invalid
projection is passed. Otherwise, the function returns "NA", Default: TRUE}

\item{verbose}{\code{logical} if TRUE, return messages}
}
\value{
\code{character} proj4string of the object or file
}
\description{
helper function used to check that the input projection
(passed as UTM zone, EPSG code, WKT string) is a valid projection for MODIStsp.
}
\note{
This function was forked from package \code{sprawl}, version 0.3.0.
}
\examples{

\dontrun{
check_projection("32632")

check_projection("32631")

check_projection(32633)

check_projection(30, abort = FALSE)

check_projection("example of invalid string", abort = FALSE)

proj_wkt <- sf::st_as_text(sf::st_crs(32632))
check_projection(proj_wkt)
}
}
\author{
Lorenzo Busetto, phD (2017) \href{mailto:lbusett@gmail.com}{lbusett@gmail.com}

Luigi Ranghetti, phD (2017) \href{mailto:ranghetti.l@irea.cnr.it}{ranghetti.l@irea.cnr.it}
}
