% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_subset.R
\name{mt_subset}
\alias{mt_subset}
\title{Download MODIS Land Products subsets}
\usage{
mt_subset(product, band, lat, lon, start = "2000-01-01",
  end = format(Sys.time(), "\%Y-\%m-\%d"), km_lr = 0, km_ab = 0,
  site_id, site_name = "sitename", out_dir = tempdir(),
  internal = TRUE, progress = TRUE)
}
\arguments{
\item{product}{a valid MODIS product name}

\item{band}{band to download}

\item{lat}{latitude in decimal degrees}

\item{lon}{longitude in decimal degrees}

\item{start}{start date}

\item{end}{end date}

\item{km_lr}{km left-right to sample}

\item{km_ab}{km above-below to sample}

\item{site_id}{site id (overides lat / lon)}

\item{site_name}{arbitrary site name used in writing data to file
(default = sitename)}

\item{out_dir}{path where to store the data if writing to disk
(default = tempdir())}

\item{internal}{should the data be returned as an internal data structure
\code{TRUE} or \code{FALSE} (default = \code{TRUE})}

\item{progress}{show download progress}
}
\value{
A data frame combining meta-data and actual data values.
}
\description{
Lists all available dates for a MODIS Land Products Subset product
at a particular location.
}
\examples{

\donttest{
# list all available MODIS Land Products Subsets products
# download data
subset <- mt_subset(product = "MOD11A2",
                        lat = 40,
                        lon = -110,
                        band = "LST_Day_1km",
                        start = "2004-01-01",
                        end = "2004-03-31",
                        progress = FALSE)
 head(subset)
}
}
\seealso{
\code{\link[MODISTools]{mt_sites}}
\code{\link[MODISTools]{mt_dates}} \code{\link[MODISTools]{mt_bands}}
\code{\link[MODISTools]{mt_products}}
\code{\link[MODISTools]{mt_batch_subset}}
}
\keyword{Land}
\keyword{MODIS}
\keyword{Products}
\keyword{Subsets,}
\keyword{meta-data}
\keyword{products,}
