% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transDate.R
\name{transDate}
\alias{transDate}
\title{MODIS Date Conversion and Testing}
\usage{
transDate(begin = NULL, end = NULL)
}
\arguments{
\item{begin}{\code{character}. Begin date(s) of time series, see 
\code{\link{transDate}}. If not provided, this defaults to 
\code{"1972-01-01"}.}

\item{end}{\code{character}. End date of MODIS time series. If not provided, 
this defaults to \code{Sys.Date()}.}
}
\value{
A \code{list} of begin and end dates formatted according to 'YYYY-MM-DD' 
(first two slots; class \code{Date}) and 'YYYYDDD' (second two slots; class 
\code{character}).
}
\description{
This function converts a sequence of input dates to 'YYYY-MM-DD' and 
'YYYYDDD'.
}
\examples{
transDate()
transDate(begin="2009.01.01")
transDate(end="2009.01.01")
transDate(begin="2009-01-01",end="2011.03.16")
               
}
\author{
Matteo Mattiuzzi
}

