% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addAccessibilityShift.R
\name{addAccessibilityShift}
\alias{addAccessibilityShift}
\title{\code{addAccessibilityShift}}
\usage{
addAccessibilityShift(CountSE, foreground, background, assayName = NULL)
}
\arguments{
\item{CountSE}{The SummarizedExperiment object output from extractRegion}

\item{foreground}{Group that will be used as the foreground for the subtraction of accessibility}

\item{background}{Group that will be used as the background for the subtraction of accessibility}

\item{assayName}{The name given to the new assay that is difference in accessibility between foreground and background.}
}
\value{
countSE a SummarizedExperiment containing coverage for the given input cell populations.
}
\description{
\code{addAccessibilityShift} will add a new condition to the SummarizedExperiment output of extractRegion,
								which will contain the difference in accessibility between two conditions
}
\examples{
\dontrun{
# CountSE is a SummarizedExperiment generated by extractRegion()
countSE <- MOCHA::addAccessibilityShift(
  CountSE = CountSE,
  foreground = "Condition1",
  background = "Condition2",
  assayName = "AccessibilityChanges"
)
}
}
