% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnl_pred_ova.R
\name{mnl_pred_ova}
\alias{mnl_pred_ova}
\title{Multinomial Prediction Function (Observed Value Approach)}
\usage{
mnl_pred_ova(
  model,
  data,
  xvari,
  by = NULL,
  scenname = NULL,
  scenvalue = NULL,
  nsim = 1000,
  seed = "random",
  probs = c(0.025, 0.975)
)
}
\arguments{
\item{model}{the multinomial model, from a \code{\link{multinom}}()-function call (see the \code{\link{nnet}} package)}

\item{data}{the data with which the model was estimated}

\item{xvari}{the name of the variable that should be varied (the x-axis variable in prediction plots)}

\item{by}{define the steps of the \code{xvari}.}

\item{scenname}{if you want to hold a specific variable stable over all scenarios, you can name it here (optional).}

\item{scenvalue}{determine at which value you want to fix the \code{scenname}.}

\item{nsim}{numbers of simulations}

\item{seed}{set a seed for replication purposes.}

\item{probs}{a vector with two numbers, defining the significance levels. Default to 5\% significance level: \code{c(0.025, 0.975)}}
}
\value{
The function returns a list with several elements. Most importantly the list includes the simulated draws `S`, the simulated predictions `P`, and a data set for plotting `plotdata`.
}
\description{
This function predicts probabilities for all choices of a multinomial logit
model over a specified span of values.
}
\examples{
library(nnet)
library(MASS)

dataset <- data.frame(y = c(rep("a", 10), rep("b", 10), rep("c", 10)),
                      x1 = rnorm(30),
                      x2 = rnorm(30, mean = 1),
                      x3 = sample(1:10, 30, replace = TRUE))

mod <- multinom(y ~ x1 + x2 + x3, data = dataset, Hess = TRUE)

pred <- mnl_pred_ova(model = mod, data = dataset,
                     xvari = "x1",
                     nsim = 10)


}
