% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampler.R
\name{rMNAR}
\alias{rMNAR}
\title{Function used to simulate data from mixture model with specific missingness mechanism}
\usage{
rMNAR(
  n,
  K,
  d = 3,
  delta = 3,
  gamma = 1,
  law = "gauss",
  linkmissing = "logit-X"
)
}
\arguments{
\item{n}{sample size (numeric of length 1)}

\item{K}{number of clusters (numeric of length 1)}

\item{d}{number of variables (numeric of length 1)}

\item{delta}{tuning parameter to define the rate of misclassification (numeric of length 1)}

\item{gamma}{tuning parameter to define the rate of missingness (numeric of length 1)}

\item{law}{specifies the distribution of the variables within components (character that must be equal to gauss, student, laplace or skewgauss)}

\item{linkmissing}{specify the missingness mechanism (character that must be equal to MCAR, logit-Z, logit-X or censoring)}
}
\value{
rMNAR returns a list containing the observed data (x), the true cluster membership (z), the complete data (xfull), the cluster membership given by the Baye's rule (zhat), the empirical rates of misclassification (meanerrorclass) and missngness (meanmiss).
}
\description{
Generation of data set to perform the simulation presented in Section 4.1 of Du Roy de Chaumaray (2020)
}
\examples{
set.seed(123)
# Data generation
ech <- rMNAR(n=100, K=3, d=3, delta=2, gamma=1)
# Head of the observed data
head(ech$x)
# Table of the cluster memberships
table(ech$z)
# Empirical rate of misclassification
ech$meanerrorclass
# Empirical rate of missingness
ech$meanmiss

}
\references{
Clustering Data with Non-Ignorable Missingness using Semi-Parametric Mixture Models, Marie Du Roy de Chaumaray and  Matthieu Marbac <arXiv:2009.07662>.
}
