% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{predint_plot}
\alias{predint_plot}
\title{Plot of typical and deviant cases with prediction intervals}
\usage{
predint_plot(pred_df)
}
\arguments{
\item{pred_df}{A dataframe created with \code{\link{predint}}.}
}
\value{
A plot of the observed outcome against the fitted outcome with
prediction intervals and case classifications. Created with
\code{\link{ggplot2}}.
}
\description{
Presented in Rohlfing, Ingo and Peter Starke (2013):
Building on Solid Ground: Robust Case Selection in Multi-Method Research.
\emph{Swiss Political Science Review} 19 (4): 492-512.
(\url{https://doi.org/10.1111/spsr.12052})
}
\examples{
df <- lm(mpg ~ disp + wt, data = mtcars)
predint_status <- predint(df, piwidth = 0.9)
predint_plot(predint_status)

}
