% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Classification.R
\name{LogLoss}
\alias{LogLoss}
\title{Log loss/Cross-Entropy Loss}
\usage{
LogLoss(y_true, y_pred)
}
\arguments{
\item{y_true}{Ground truth (correct) 0-1 labels vector}

\item{y_pred}{Predicted labels vector, as returned by a classifier}
}
\value{
Log loss/Cross-Entropy Loss
}
\description{
Compute the log loss/cross-entropy loss.
}
\examples{
data(cars)
logreg <- glm(formula=vs~hp+wt, family=binomial(link = "logit"), mtcars)
LogLoss(y_true=mtcars$vs, y_pred=logreg$fitted.values)
}

