% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{plot,MLZ_data-method}
\alias{plot,MLZ_data-method}
\alias{plot.MLZ_data}
\title{\code{plot} method for S4 class \code{MLZ_data}}
\usage{
\S4method{plot}{MLZ_data}(x, type = c("ML", "comp"),
  ggplot_layer = NULL)
}
\arguments{
\item{x}{An object of class \code{MLZ_data}.}

\item{type}{Character. \code{"comp"} produces a annual length frequencies from ggplot2, while \code{"ML"}
plots mean lengths from slot \code{MLZ_data@ML}, as well as data from 
\code{MLZ_data@CPUE} and \code{MLZ_data@Effort} if available..}

\item{ggplot_layer}{Optional layers to add to ggplot2 plot for \code{type = "comp"}.}
}
\description{
Plots annual length frequencies from slot \code{Len_matrix} or \code{Len_df}. If there are data in 
both slots, \code{Len_matrix} is preferentially plotted.
}
\examples{
\dontrun{
data(Nephrops)
plot(Nephrops)
plot(Nephrops, type = "ML")
}
}
