% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_vae_correlated.R
\name{build_vae_correlated}
\alias{build_vae_correlated}
\title{Build a VAE that fits to a normal, full covariance N(m,S) latent distribution}
\usage{
build_vae_correlated(
  num_items,
  num_skills,
  Q_matrix,
  mean_vector = rep(0, num_skills),
  covariance_matrix = diag(num_skills),
  model_type = 2,
  enc_hid_arch = c(ceiling((num_items + num_skills)/2)),
  hid_enc_activations = rep("sigmoid", length(enc_hid_arch)),
  output_activation = "sigmoid",
  kl_weight = 1,
  learning_rate = 0.001
)
}
\arguments{
\item{num_items}{an integer giving the number of items on the assessment; also the number of nodes in the input/output layers of the VAE}

\item{num_skills}{an integer giving the number of skills being evaluated; also the dimensionality of the distribution learned by the VAE}

\item{Q_matrix}{a binary, \code{num_skills} by \code{num_items} matrix relating the assessment items with skills}

\item{mean_vector}{a vector of length \code{num_skills} specifying the mean of each latent trait; the default of \code{rep(0, num_skills)} should almost always be used}

\item{covariance_matrix}{a symmetric, positive definite, \code{num_skills} by \code{num_skills} matrix giving the covariance of the latent traits}

\item{model_type}{either 1 or 2, specifying a 1 parameter (1PL) or 2 parameter (2PL) model; if 1PL, then all decoder weights are fixed to be equal to one}

\item{enc_hid_arch}{a vector detailing the size of hidden layers in the encoder; the number of hidden layers is determined by the length of this vector}

\item{hid_enc_activations}{a vector specifying the activation function in each hidden layer in the encoder; must be the same length as \code{enc_hid_arch}}

\item{output_activation}{a string specifying the activation function in the output of the decoder; the ML2P model always used 'sigmoid'}

\item{kl_weight}{an optional weight for the KL divergence term in the loss function}

\item{learning_rate}{an optional parameter for the adam optimizer}
}
\value{
returns three keras models: the encoder, decoder, and vae
}
\description{
Build a VAE that fits to a normal, full covariance N(m,S) latent distribution
}
\examples{
\donttest{
Q <- matrix(c(1,0,1,1,0,1,1,0), nrow = 2, ncol = 4)
cov <- matrix(c(.7,.3,.3,1), nrow = 2, ncol = 2)
models <- build_vae_correlated(4, 2, Q,
          mean_vector = c(-0.5, 0), covariance_matrix = cov,
          enc_hid_arch = c(6, 3), hid_enc_activation = c('sigmoid', 'relu'),
          output_activation = 'tanh',
          kl_weight = 0.1)
vae <- models[[3]]
}
}
