% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mims_unit.R
\name{mims_unit}
\alias{mims_unit}
\alias{mims_unit_from_files}
\title{Compute Monitor Independent Motion Summary unit (MIMS-unit)}
\usage{
mims_unit_from_files(
  files,
  epoch = "5 sec",
  dynamic_range,
  output_mims_per_axis = FALSE,
  use_gui_progress = FALSE,
  file_type = "mhealth",
  ...
)

mims_unit(
  df,
  before_df = NULL,
  after_df = NULL,
  epoch = "5 sec",
  dynamic_range,
  output_mims_per_axis = FALSE,
  use_gui_progress = FALSE,
  st = NULL
)
}
\arguments{
\item{files}{character vector. A list of csv filepaths for raw accelerometer
data organized in order to be processed. The data should be consecutive in
timestamps. A typical case is a set of hourly or daily files for
continuous accelerometer sampling.}

\item{epoch}{string. Any format that is acceptable by argument \code{breaks}
in method \code{\link[base]{cut.POSIXt}}.For example, "1 sec", "1 min", "5
sec", "10 min". Default is "5 sec".}

\item{dynamic_range}{numerical vector. The dynamic ranges of the input
signal. Should be a 2-element numerical vector. \code{c(low, high)}, where
\code{low} is the negative max value the device can reach and \code{high}
is the positive max value the device can reach.}

\item{output_mims_per_axis}{logical. If it is TRUE, the output MIMS-unit
dataframe will have MIMS-unit values for each axis from the third column.
Default is FALSE.}

\item{use_gui_progress}{logical. If it is TRUE, show GUI progress bar on
windows platform. Default is FALSE.}

\item{file_type}{character. "mhealth" or "actigraph". The type of the csv files
that store the raw accelerometer data.}

\item{...}{additional parameters passed to the import function when reading
in the data from the files.}

\item{df}{dataframe. Input multi-channel accelerometer signal.  The
first column should be the time component}

\item{before_df}{dataframe. The multi-channel accelerometer signal comes
before the input signal to be prepended to the input signal during
computation. This is used to eliminate the edge effect during extrapolation
and filtering. If it is \code{NULL}, algorithm will run directly on the
input signal. Default is NULL.}

\item{after_df}{dataframe. The multi-channel accelerometer signal comes after
the input signal to be append to the input signal. This is used to
eliminate the edge effect during extrapolation and filtering. If it is
\code{NULL}, algorithm will run directly on the input signal. Default is
NULL.}

\item{st}{character or POSIXct timestamp. An optional start time you can set to
force the epochs generated by referencing this start time. If it is NULL, the
function will use the first timestamp in the timestamp column as start time to
generate epochs. This is useful when you are processing a stream of data and
want to use a common start time for segmenting data. Default is NULL.}
}
\value{
dataframe. The MIMS-unit dataframe. The first column is the start
  time of each epoch in POSIXct format. The second column is the MIMS-unit
  value for the input signal. If \code{output_mims_per_axis} is TRUE, the
  third column and then are the MIMS-unit values for each axis of the input
  signal.
}
\description{
\code{mims_unit} computes the Monitor Independent Motion Summary unit for the
input multi-channel accelerometer signal. The input signal can be from
devices of any sampling rate and dynamic range. Please refer to the
manuscript for detailed description of the algorithm. Please refer to
functions for the intermediate steps: \code{\link{extrapolate}} for
extrapolation, \code{\link{iir}} for filtering,
\code{\link{aggregate_for_mims}} for aggregation.
}
\note{
This function is a wrapper function for the low-level
  \code{\link{custom_mims_unit}} function. It has set internal parameters as
  described in the manuscript. If you want to run customized algorithm for
  MIMSunit or if you want to develop better algorithms based on MIMS-unit
  algorithm, please use function \code{\link{custom_mims_unit}} where all
  parameters are tunable.

  \code{before_df} and \code{after_df} are often set when the accelerometer
  data are divided into files of smaller chunk.
}
\section{How is it used in MIMS-unit algorithm?}{
 This is the main entry of
  MIMS-unit algorithm.
}

\examples{
  # Use sample mhealth file for testing
  filepaths = c(
    system.file('extdata', 'mhealth.csv', package='MIMSunit'),
    system.file('extdata', 'mhealth1.csv', package='MIMSunit')
  )

  # Test with single file
  mims_unit_from_files(c(filepaths[1]),
                                epoch = "10 sec",
                                dynamic_range = c(-2, 2))

  # Test with multiple files
  mims_unit_from_files(filepaths, epoch = "20 sec", dynamic_range = c(-2, 2))
  # Use sample data for testing
  df = sample_raw_accel_data

  # compute mims unit values
  mims_unit(df, epoch = '5 min', dynamic_range=c(-8, 8))

  # compute mims unit values with different epoch length
  output = mims_unit(df, epoch = '15 sec', dynamic_range=c(-8, 8))
  head(output)

  # output axial values
  output = mims_unit(df, epoch = '15 sec', dynamic_range=c(-8, 8), output_mims_per_axis=TRUE)
  head(output)
}
\seealso{
Other Top level API functions: 
\code{\link{custom_mims_unit}()},
\code{\link{sensor_orientations}()}
}
\concept{Top level API functions}
