% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FWERSS.R
\name{Tarone.p.adjust}
\alias{Tarone.p.adjust}
\title{The adjusted p-values for Tarone's single-step FWER controlling procedure.}
\usage{
Tarone.p.adjust(p,p.set)
}
\arguments{
\item{p}{numeric vector of p-values (possibly with \code{\link[base]{NA}}s). Any other R is coerced by \code{\link[base]{as.numeric}}. Same as in \code{\link[stats]{p.adjust}}.}

\item{p.set}{a list of numeric vectors, where each vector is the vector of all attainable p-values containing the available p-value for the corresponding hypothesis.}
}
\value{
A numeric vector of the adjusted p-values (of the same length as \eqn{p}).
}
\description{
The function for calculating the adjusted p-values based on original available p-values and all attaianble p-values.
}
\examples{
p <- c(pbinom(1,8,0.5),pbinom(1,5,0.75),pbinom(1,6,0.6))
p.set <-list(pbinom(0:8,8,0.5),pbinom(0:5,5,0.75),pbinom(0:6,6,0.6))
Tarone.p.adjust(p,p.set)
}
\author{
Yalin Zhu
}
\references{
Tarone, R. E. (1990).
A modified Bonferroni method for discrete data.
\emph{Biometrics}, \strong{46}: 515-522.
}

