% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-SplitDrive.R
\name{cubeSplitDrive}
\alias{cubeSplitDrive}
\title{Inheritance Cube: Split CRISPR drive with 2 Resistance Alleles and male/female specific homing}
\usage{
cubeSplitDrive(
  cM = 1,
  cF = 1,
  chM = 0,
  crM = 0,
  chF = 0,
  crF = 0,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cM}{Cutting efficiency in males}

\item{cF}{Cutting efficiency in females}

\item{chM}{Homing efficiency in males}

\item{crM}{Resistance efficiency in males}

\item{chF}{Homing efficiency in females}

\item{crF}{Resistance efficiency in females}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This is a sex-specific version of a split CRISPR drive. At one locus is the Cas9, inherited
in a Mendelian fashion. At a second, unlinked, locus are the gRNAs. When the two loci occur
together, the gRNAs drive, with potential damaged alleles, but the Cas9 remains
Mendelian. It is assumed that this is an autosomal drive.
This drive corresponds to the \href{https://elifesciences.org/articles/51701}{confinable gene drive system}
developed by the Akbari lab.
}
