% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGDrivE-Auxiliary.R
\name{calcQuantiles}
\alias{calcQuantiles}
\title{Summary Statistics for Stochastic MGDrivE}
\usage{
calcQuantiles(readDir, writeDir, mean = TRUE, quantiles = NULL,
  numCores = 1, verbose = TRUE)
}
\arguments{
\item{readDir}{Directory to find repetition folders in}

\item{writeDir}{Directory to write output}

\item{mean}{Boolean, calculate mean or not. Default is TRUE}

\item{quantiles}{Vector of quantiles to calculate. Default is NULL}

\item{numCores}{Number of cores when reading/writing. Default is 1.}

\item{verbose}{Chatty? Default is TRUE}
}
\value{
Writes output to files in writeDir
}
\description{
This function reads in all repetitions for each patch and calculates either
the mean, quantiles, or both. User chooses the quantiles, up to 4 decimal places,
and enters them as a vector. Quantiles are calculated empirically. (order does not matter)  \cr
}
\details{
Given the readDir, this function assumes the follow file structure: \cr
\itemize{
\item readDir
\itemize{
\item repetition 1
\itemize{
\item patch 1
\item patch 2
\item patch 3
}
\item repetition 2
\itemize{
\item patch 1
\item patch 2
\item patch 3
}
\item repetition 3
\item repetition 4
\item ... \cr
}
}

Output files are *.csv contain the mean or quantile in the file name, i.e.
{M/F}\emph{Mean}(patchNum).csv and {M/F}\emph{Quantile}(quantNum)_(patchNum).csv.
}
\examples{
\dontrun{
# This function assumes network$multRun() has been performed, or several
#  network$oneRun() have been performed and all of the data has been split
#  and aggregated.

# read/write paths
fPath <- "path/to/folder/ofFolders/with/data"
oPath <- "my/path/output"

# here, only calculate mean, no quantiles
#  no return value
calcQuantiles(readDir = fPath, writeDir = oPath, mean = TRUE,
              quantiles = NULL, numCores = 1)

# here, calculate 2.5\% and 97.5\% quantiles
calcQuantiles(readDir = fPath, writeDir = oPath, mean = FALSE,
              quantiles = c(0.025, 0.975), numCores = 1)
}

}
