% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check}
\alias{check}
\title{Check model for influential cases}
\usage{
check(object, ...)
}
\arguments{
\item{object}{object of class \code{lm}.}

\item{...}{other parameters (none are used at the moment).}
}
\value{
\code{check} returns a list containing two matrices with statistics regarding
influential cases and a vector of variance inflation factors. Furthermore, it
produces diagnostics plots.\cr
The return list contains three elements:\cr \cr
- \code{influence}, a \code{data.frame}, with observations in the model,
and the following variables:
\item{predicted.value}{The value predicted by the model.}
\item{residual}{The raw residual.}
\item{std.residual}{The standardized residual.}
\item{dfb.<...>}{DFBETAs for the variables in the model.}
\item{dffit}{DFFIT value.}
\item{cov.r}{Covariance ratio, a measure of change in the determinant of
the coefficient covariance matrix.}
\item{cook.d}{Cook's distance.}
\item{hat}{Hat values.}
\item{influential}{Determines whether a case is influential on any of the
measures \code{dfb.<...>}, \code{dffit}, \code{cov.r}, \code{cook.d} or \code{hat}.
See \code{influential cases} for more information.}
\cr\cr
- \code{is.infl} is a \code{data.frame} indicating which influence measure(s)
is/are flagged per observation.
\cr\cr
- \code{vifs}, a vector containing variance inflation factors for the
variables in the model.
\cr\cr
By default, the two \code{data.frame}s regarding influence measures only give the influence
measures for cases that are flagged as being influential. Influence measures for all cases
can be queried using \code{\link{print.check.lm}}.
\cr\cr
The generated plots are the plots produced by \code{\link[stats]{plot.lm}}, numbers 1 through 6.
}
\description{
Perform checks for a linear model regarding influential cases and collinearity
numerically and graphically.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\section{influential cases}{


For the influence indicators, the following rules are applied to check whether a case
is influential:
\itemize{
\item \eqn{\mathrm{any\enspace}|\mathrm{dfbeta}| > 1}.
\item \eqn{|\mathrm{dffit}| > 3 \sqrt{\frac{k}{n-k}}}.
\item \eqn{|1 - \mathrm{cov.r}| > \frac{3k}{n-k}}.
\item \eqn{F\mathrm{(}n, n-k \mathrm{)} = \mathrm{cooks.d\enspace having\enspace}.
  p > .5}
\item \eqn{\mathrm{hat} > \frac{3k}{n}}.
}
These indicators for being an influential case were derived from
\code{\link[stats]{influence.measures}} in the \code{stats} package.
}

\examples{
lm.1 <- lm(mpg ~ disp + wt, data = mtcars)
check(lm.1)
}
\author{
Mathijs Deen
}
