% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simS.R
\name{simS}
\alias{simS}
\title{Covariance Matrix Simulation}
\usage{
simS(doses, resp, nSample, Ntype = c("arm", "total", "actual"),
  nSim = 1000, alRatio = NULL, family, link, modelPar = NULL,
  placEff = NULL, verbose = FALSE)
}
\arguments{
\item{doses}{A numerical vector of doses, corresponding to the theoretical
response values provided.}

\item{resp}{A numeric vector of response values corresponding to the doses.
This should be on the link scale (e.g. \code{resp} should be on the
log-scale if using the log-link).}

\item{nSample}{An integer if \code{Ntype} is "arm" or "total", or a numerical
vector of patient allocations for each arm if \code{Ntype} is "actual".}

\item{Ntype}{One of "arm", "total", or 'actual". See documentation for
\code{Ntype} in \code{\link[DoseFinding:powMCT]{powMCT}} for descriptions
of "arm" and 'total". For "actual", the nSample should be a numerical
vector containing the actual patient allocation for each dose provided.}

\item{nSim}{An integer specifying the number of simulations used to estimate
the covariance matrix.}

\item{alRatio}{Vector describing the relative patient allocations to the dose
groups up to proportionality, e.g. \code{rep(1, length(doses))} corresponds
to balanced allocations.}

\item{family}{A character string containing the error distribution to be used
in the model.}

\item{link}{A character string specifying the link to be using when modeling
the glm.}

\item{modelPar}{A numeric vector containing the additional parameters for the
family argument. If the family is negative binomial, the dispersion
parameter should be supplied. If the family is binomial, no model parameter
should be supplied.}

\item{placEff}{A numeric value specifying the mean response at the placebo
This is required if \code{link} = "risk ratio" or "log risk ratio" and
ignored otherwise.}

\item{verbose}{A logical specifying whether the patient allocation should be
printed, in addition to the results.}

\item{...}{For all other arguments, see the documentation in
\code{\link[DoseFinding:powMCT]{powMCT}}.}
}
\value{
Numeric containing the estimated covariance matrix.
}
\description{
For non-canonical links, simulating the covariance matrix is sometimes the
easiest way to get an estimate of the covariance matrix. Even for the
canonical links, simulating the covariance matrix may be desirable, as
theoretical covariance matrices are based off of asymptotic properties which
may not hold for small sample sizes.
}
\examples{
data(migraine)
models = Mods(linear = NULL, emax = 1, quadratic = c(-0.004), doses = migraine$dose)
simS(migraine$dose, getResp(models)[,1], 30, "arm", 10, family = "binomial",
     link = "logit", verbose = TRUE)
}
