% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.functions.R
\name{devplot}
\alias{devplot}
\title{Plot deviance contributions from an MBNMA model}
\usage{
devplot(mbnma, dev.type = "resdev", plot.type = "scatter",
  xaxis = "time", facet = TRUE, n.iter = mbnma$BUGSoutput$n.iter,
  n.thin = mbnma$BUGSoutput$n.thin, ...)
}
\arguments{
\item{mbnma}{An S3 object of class \code{"mbnma"} generated by running
a time-course MBNMA model}

\item{dev.type}{Deviances to plot - can be either residual deviances (\code{"resdev"}, the
default) or deviances (\code{"dev"})}

\item{plot.type}{Deviances can be plotted either as scatter points (\code{"scatter"} - using
\code{geom_point()}, the default) or as boxplots (\code{"box"})}

\item{xaxis}{A character object that indicates whether deviance contributions should be plotted
by time (\code{"time"}) or by follow-up count (\code{"fup"})}

\item{facet}{A boolean object that indicates whether or not to facet by treatment}

\item{n.iter}{The number of iterations to update the model whilst monitoring additional parameters (if necessary).
Must be a positive integer. Default is the value used in \code{mbnma}.}

\item{n.thin}{The thinning rate. Must be a positive integer. Default is the value used in \code{mbnma}.}

\item{...}{Arguments to be sent to \code{ggplot2::geom_point()} or \code{ggplot2::geom_boxplot}}
}
\value{
Generates a plot of deviance contributions and returns a list containing the
plot (as an object of class \code{c("gg", "ggplot")}), and a data.frame of posterior mean
deviance/residual deviance contributions for each observation.
}
\description{
Plot deviance contributions from an MBNMA model
}
\details{
Deviances should only be plotted for models that have converged successfully. If deviance
contributions have not been monitored in \code{mbnma$parameters.to.save} then additional
iterations will have to be run to get results for these.

Deviance contributions cannot be calculated for models with a multivariate likelihood (i.e.
those that account for correlation between observations) because the covariance matrix in these
models is treated as unknown (if \code{rho="estimate"}) and deviance contributions will be correlated.
}
\examples{
\donttest{
# Make network
network <- mb.network(alog_pcfb)

# Run MBNMA
mbnma <- mb.quadratic(network)

# Plot residual deviance contributions in a scatterplot
devplot(mbnma)

# Plot deviance contributions in boxplots at each follow-up measurement
# Monitor for 500 additional iterations
devplot(mbnma, dev.type="dev", plot.type="box", xaxis="fup", n.iter=500)
}
}
