% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_08_DE_2_5_PlotDEValues_Gene_Mean_Spliced.R
\name{PlotDEValues.Exp.Spliced}
\alias{PlotDEValues.Exp.Spliced}
\title{Plot differential gene expression analysis of differentially spliced genes}
\usage{
PlotDEValues.Exp.Spliced(
  MarvelObject,
  method,
  psi.pval = 0.1,
  psi.delta = 0,
  gene.pval = 0.1,
  gene.log2fc = 0.5,
  point.size = 1,
  anno = FALSE,
  anno.gene_short_name = NULL,
  label.size = 2.5,
  y.upper.offset = 5,
  xlabel.size = 8
)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CompareValues} function.}

\item{method}{(Vector of) Character string(s). The \code{method} specified in \code{CompareValues} function when \code{level} option set to \code{"splicing"}.}

\item{psi.pval}{Numeric value. The adjusted p-value from differential splicing analysis, below which, the splicing event is considered differentially spliced. Default is \code{0.1}.}

\item{psi.delta}{Numeric value. The absolute differences in average PSI value between two cell groups from differential splicing analysis, above which, the splicing event is considered differentially spliced.  Default is \code{0}.}

\item{gene.pval}{Numeric value. The adjusted p-value from differential gene expression analysis, below which, the gene is considered differentially expressed. Default is \code{0.1}.}

\item{gene.log2fc}{Numeric value. The absolute log2 fold change in gene expression betwene two cell groups from differential splicing analysis, above which, the gene is considered differentially expressed. Default is \code{0.5}.}

\item{point.size}{Numeric value. Size of data points. Default is \code{1}.}

\item{anno}{Logical value. If set to \code{TRUE}, the specific gene names will be annotated on the plot as defined in \code{anno.gene_short_name} option.}

\item{anno.gene_short_name}{Vector of character strings. When \code{anno} set to \code{TRUE}, the gene names to be annotated on the plot.}

\item{label.size}{Numeric value. Only applicable if \code{anno} set to TRUE. Size of the gene name labels.}

\item{y.upper.offset}{Numeric value. The value in -log10(p-value) to increase the upper limit of the y-axis. To be used when \code{anno} set to TRUE so that gene labels will not be truncated at the upper limit of the y-axis.}

\item{xlabel.size}{Numeric value. Font size of the xtick labels. Default is \code{8}.}
}
\value{
An object of class S3 with new slots \code{MarvelObject$DE$Exp.Spliced$Table}, \code{MarvelObject$DE$Exp.Spliced$Summary}, and \code{MarvelObject$DE$Exp.Spliced$Plot}.
}
\description{
Volcano plot of differential splicing analysis results based on differentially spliced genes between 2 groups of cells. x-axis represents the log2 fold change in gene expression. y-axis represents the adjusted p-values.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- PlotDEValues.Exp.Spliced(MarvelObject=marvel.demo,
                                        method="ad",
                                        psi.pval=0.1,
                                        psi.delta=0,
                                        gene.pval=0.1,
                                        gene.log2fc=0.5
                                        )
# Check output
marvel.demo$DE$Exp.Spliced$Summary
marvel.demo$DE$Exp.Spliced$Plot
}
