% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_DROPLET_05_DE_6_1_GO.R
\name{BioPathways.10x}
\alias{BioPathways.10x}
\title{Pathway enrichment analysis}
\usage{
BioPathways.10x(
  MarvelObject,
  pval = 0.05,
  log2fc = NULL,
  delta = 5,
  min.gene.norm = 0,
  method.adjust = "fdr",
  custom.genes = NULL,
  species = "human",
  remove.ribo = FALSE
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CompareValues.Genes.10x} function.}

\item{pval}{Numeric value. p-value, above which, the splice junction is considered differentially spliced. Default is \code{0.05}.}

\item{log2fc}{Numeric value. Absolute log2 fold change from differential splicing analysis, above which, the splice junction is considered differentially spliced. This option should be \code{NULL} if \code{delta} has been specified.}

\item{delta}{Numeric value. Absolute difference in average PSI values between the two cell groups, above which, the splice junction is considered differentially spliced. This option should be \code{NULL} if \code{log2fc} has been specified.}

\item{min.gene.norm}{Numeric value. The average normalised gene expression across the two cell groups above which the splice junction is considered differentially spliced. Default is \code{0}.}

\item{method.adjust}{Character string. Adjust p-values for multiple testing. Options available as per \code{p.adjust} function.}

\item{custom.genes}{Character strings. Alternative to \code{pval} and \code{delta}. Vector of gene names to be assessed for enrichment of biological pathways.}

\item{species}{Character strings. Takes the value \code{"human"} or \code{"mouse"}, which corresponds to human and mouse genes, respectively. Default value is \code{"human"}.}

\item{remove.ribo}{Logical value. If set to \code{TRUE}, ribosomal genes will be removed prior to GO analysis. This may prevent high-expressing ribosomal genes from overshadowing more biological relevant genes for GO analysis. Default value is \code{FALSE}.}

\item{method}{Character string. The statistical method used for differential splicing analysis.}
}
\value{
An object of class S3 containing new slot \code{MarvelObject$DE$BioPathways$Table}.
}
\description{
Performs pathway enrichment analysis on differentially spliced genes or user-specified custom set of genes.
}
\examples{

marvel.demo.10x <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.rds",
                               package="MARVEL")
                               )

marvel.demo.10x <- BioPathways.10x(
                        MarvelObject=marvel.demo.10x,
                        custom.genes=c("TPM2", "GNAS"),
                        species="human"
                        )
}
