% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{print.MAMS}
\alias{print.MAMS}
\title{Generic print function for class MAMS.}
\usage{
\method{print}{MAMS}(x, digits = max(3, getOption("digits") - 4), ...)
}
\arguments{
\item{x}{An output object of class MAMS}

\item{digits}{Number of significant digits to be printed.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Text output.
}
\description{
Generic print function for class MAMS.
}
\details{
print produces a brief summary of an object from class MAMS
including boundaries and requires sample size if initially requested.
}
\examples{
\donttest{
# 2-stage design with triangular boundaries
res <- mams(K=4, J=2, alpha=0.05, power=0.9, r=1:2, r0=1:2, 
             p=0.65,p0=0.55,
             ushape="triangular", lshape="triangular", nstart=30)

print(res)
}
}
\references{
Magirr D, Jaki T, Whitehead J (2012) A generalized Dunnett test for multi-arm
multi-stage clinical studies with treatment selection.
Biometrika, 99(2), 494-501. Stallard N, Todd S (2003) Sequential designs for
phase III clinical trials
incorporating treatment selection. Statistics in Medicine, 22(5), 689-703.
Magirr D, Stallard N, Jaki T (2014) Flexible sequential designs for multi-arm
clinical trials. Statistics in Medicine, 33(19), 3269-3279.
}
\seealso{
\link{mams}, \link{stepdown.mams}.
}
\author{
Thomas Jaki, Dominic Magirr, Philip Pallmann
}
\keyword{classes}
