% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterMAF.R
\name{filter_maf_chunked}
\alias{filter_maf_chunked}
\title{Function to filter the mutations}
\usage{
filter_maf_chunked(
  maf_file,
  chunk_lines = 10000,
  flag_genes = "default",
  save_name = NULL,
  no_filter = FALSE,
  grep_vcf_filter_col = "PASS",
  non_silent_only = FALSE,
  t_alt_min = 2,
  t_depth_min = 5,
  tumor_freq_min = 0.01,
  n_alt_max = 1,
  norm_freq_max = 0.01,
  gnomAD_AF_max = 0.001,
  AF_max = 0.001,
  ExAC_AF_max = 0.001,
  n_callers = 2,
  variant_caller = NULL
)
}
\arguments{
\item{maf_file}{The path of the file containing the mutation
information in the MAF format}

\item{chunk_lines}{The number of lines to be read at once}

\item{flag_genes}{The list of genes used as flag genes}

\item{save_name}{The name and path of the output file to save filtered MAFs}

\item{no_filter}{Flag to filter the MAF (Default no_filter=FALSE)}

\item{grep_vcf_filter_col}{FILTER column (Default grep_vcf_filter_col="PASS")}

\item{non_silent_only}{Flag to filter non slient SNVs only
(Default non_silent_only=FALSE)}

\item{t_alt_min}{Alt t min (Default t_alt_min=1)}

\item{t_depth_min}{Depth t min (Default t_depth_min=20)}

\item{tumor_freq_min}{Tumor Frequency Minimum (Default tumor_freq_min=0.05)}

\item{n_alt_max}{Alt norm max (Default n_alt_max=1)}

\item{norm_freq_max}{norm_freq_max (Default norm_freq_max=0.02)}

\item{gnomAD_AF_max}{gnomAD_AF_max (Default gnomAD_AF_max=0.001)}

\item{AF_max}{1000 genome data AF_max (Default AF_max=0.001)}

\item{ExAC_AF_max}{ExAC_AF_max (Default ExAC_AF_max=0.01)}

\item{n_callers}{n_callers (Default n_callers=2)}

\item{variant_caller}{variant_caller}
}
\value{
An object of class MAF with the filtered mutations
}
\description{
This function reads the the big MAF files in chunks and filter
the mutations using various features
}
\examples{
library(MAFDash)
maf <- system.file("extdata", "test.mutect2.maf.gz", package = "MAFDash")
filteredMAF <- filter_maf_chunked(maf_file = maf)

}
\author{
Mayank Tondon, Ashish Jain
}
