/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape3;

import java.awt.event.ActionEvent;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.vizmap.VisualMappingManager;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.AbstractClusterONEAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ClusterONECytoscapeApp;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ControlPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CyNetworkUtil;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.Graph;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.VisualStyleManager;

public class AffinityColouringAction
extends AbstractClusterONEAction {
    public AffinityColouringAction(ClusterONECytoscapeApp app) {
        super(app, "Color nodes by affinity", "selectedNodes");
        this.putValue("LongDescription", "Color the nodes of the selected network by their affinity to the currently selected set of nodes as a cluster");
        this.putValue("MnemonicKey", 65);
        this.installInMenu();
    }

    public void actionPerformed(ActionEvent event) {
        String weightAttr;
        ControlPanel panel = this.app.getControlPanel();
        if (panel == null) {
            this.app.showErrorMessage("You must open the Control Panel before starting ClusterONE");
            return;
        }
        CyNetwork network = this.app.getCurrentNetwork();
        Graph graph = this.app.convertCyNetworkToGraph(network, weightAttr = panel.getWeightAttributeName());
        if (graph == null) {
            return;
        }
        List<Integer> indices = graph.getMappedNodeIndices(CyNetworkUtil.getSelectedNodes(network));
        this.app.setAffinityAttributes(network, graph, indices);
        VisualStyleManager vsm = this.app.getVisualStyleManager();
        vsm.ensureVizMapperStylesRegistered();
        vsm.updateAffinityStyleRange(network);
        this.app.getService(VisualMappingManager.class).setCurrentVisualStyle(vsm.getColorNodesByAffinityVisualStyle());
        if (this.app.getCurrentNetworkView() != null) {
            this.app.getCurrentNetworkView().updateView();
        }
    }
}

