/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import uk.ac.rhul.cs.cl1.DummyQualityFunction;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.QualityFunction;
import uk.ac.rhul.cs.cl1.io.AbstractClusteringWriter;
import uk.ac.rhul.cs.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVClusteringWriter
extends AbstractClusteringWriter {
    private String columnSep;
    private String doubleQuoteChar;
    private String quoteChar;
    private String quoteTriggers;
    private QualityFunction qualityFunction = null;

    public CSVClusteringWriter() {
        this(",", "\"");
    }

    public CSVClusteringWriter(String columnSep, String quoteChar) {
        this.setColumnSeparator(columnSep);
        this.setQuoteChar(quoteChar);
        this.setQualityFunction(null);
    }

    public void setColumnSeparator(String columnSep) {
        this.columnSep = columnSep;
        this.quoteTriggers = " " + this.columnSep + this.quoteChar;
    }

    public void setQualityFunction(QualityFunction qualityFunction) {
        if (qualityFunction == null) {
            qualityFunction = new DummyQualityFunction();
        }
        this.qualityFunction = qualityFunction;
    }

    public void setQuoteChar(String quoteChar) {
        this.quoteChar = quoteChar;
        this.quoteTriggers = " " + this.columnSep + this.quoteChar;
        this.doubleQuoteChar = this.quoteChar + this.quoteChar;
    }

    @Override
    public void writeClustering(List<? extends NodeSet> clustering, OutputStream stream) throws IOException {
        PrintWriter wr = new PrintWriter(stream);
        Object[] parts = new String[]{"Cluster", "Size", "Density", "Internal weight", "External weight", "Quality", "P-value", "Members"};
        int clusterIndex = 0;
        wr.println(StringUtils.join(parts, this.columnSep));
        for (NodeSet nodeSet : clustering) {
            parts[0] = Integer.toString(++clusterIndex);
            parts[1] = Integer.toString(nodeSet.size());
            parts[2] = this.quote(String.format("%.4g", nodeSet.getDensity()));
            parts[3] = this.quote(String.format("%.4g", nodeSet.getTotalInternalEdgeWeight()));
            parts[4] = this.quote(String.format("%.4g", nodeSet.getTotalBoundaryEdgeWeight()));
            parts[5] = this.quote(String.format("%.4g", this.qualityFunction.calculate(nodeSet)));
            parts[6] = this.quote(String.format("%g", nodeSet.getSignificance()));
            parts[7] = this.quote(nodeSet.toString(" "));
            wr.println(StringUtils.join(parts, this.columnSep));
        }
        wr.flush();
    }

    private String quote(String str) {
        if (!StringUtils.containsAny(str, this.quoteTriggers)) {
            return str;
        }
        return this.quoteChar + str.replace(this.quoteChar, this.doubleQuoteChar) + this.quoteChar;
    }
}

