/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util.hashmap;

import com.sosnoski.util.SparseArrayIterator;
import com.sosnoski.util.hashmap.ObjectKeyBase;
import java.util.Iterator;

public class ObjectObjectHashMap
extends ObjectKeyBase {
    protected Object[] m_keyTable;
    protected Object[] m_valueTable;
    static /* synthetic */ Class class$java$lang$Object;

    public ObjectObjectHashMap(int n, double d, Object object) {
        super(n, d, class$java$lang$Object == null ? (class$java$lang$Object = ObjectObjectHashMap.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = ObjectObjectHashMap.class$("java.lang.Object")) : class$java$lang$Object, object);
    }

    public ObjectObjectHashMap(int n, double d) {
        this(n, d, "base");
    }

    public ObjectObjectHashMap(int n, Object object) {
        this(n, 0.3, object);
    }

    public ObjectObjectHashMap(int n) {
        this(n, 0.3);
    }

    public ObjectObjectHashMap(Object object) {
        this(0, 0.3, object);
    }

    public ObjectObjectHashMap() {
        this(0, 0.3);
    }

    public ObjectObjectHashMap(ObjectObjectHashMap objectObjectHashMap) {
        super(objectObjectHashMap);
    }

    protected final Object[] getKeyArray() {
        return this.m_keyTable;
    }

    protected final void setKeyArray(Object object) {
        this.m_keyTable = (Object[])object;
    }

    protected final Object getValueArray() {
        return this.m_valueTable;
    }

    protected final void setValueArray(Object object) {
        this.m_valueTable = (Object[])object;
    }

    protected final boolean reinsert(int n) {
        Object object = this.m_keyTable[n];
        this.m_keyTable[n] = null;
        return this.assignSlot(object, this.m_valueTable[n]) != n;
    }

    protected void restructure(Object object, Object object2) {
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])object2;
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                this.assignSlot(objectArray[n], objectArray2[n]);
            }
            ++n;
        }
    }

    protected int assignSlot(Object object, Object object2) {
        int n = this.freeSlot(this.standardSlot(object));
        this.m_keyTable[n] = object;
        this.m_valueTable[n] = object2;
        return n;
    }

    public Object add(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("null key not supported");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("null value not supported");
        }
        this.ensureCapacity(this.m_entryCount + 1);
        int n = this.standardFind(object);
        if (n >= 0) {
            Object object3 = this.m_valueTable[n];
            this.m_valueTable[n] = object2;
            return object3;
        }
        ++this.m_entryCount;
        n = -n - 1;
        this.m_keyTable[n] = object;
        this.m_valueTable[n] = object2;
        return null;
    }

    public final boolean containsKey(Object object) {
        return this.standardFind(object) >= 0;
    }

    public final Object get(Object object) {
        int n = this.standardFind(object);
        if (n >= 0) {
            return this.m_valueTable[n];
        }
        return null;
    }

    public Object remove(Object object) {
        int n = this.standardFind(object);
        if (n >= 0) {
            Object object2 = this.m_valueTable[n];
            this.internalRemove(n);
            return object2;
        }
        return null;
    }

    public final Iterator valueIterator() {
        return SparseArrayIterator.buildIterator(this.m_valueTable);
    }

    public Object clone() {
        return new ObjectObjectHashMap(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

