% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_Risoe.BINfileData.R
\name{plot_Risoe.BINfileData}
\alias{plot_Risoe.BINfileData}
\title{Plot Single Luminescence Curves from a Risoe.BINfileData-class object}
\usage{
plot_Risoe.BINfileData(
  data,
  position = NULL,
  run = NULL,
  set = NULL,
  sorter = "POSITION",
  ltype = c("IRSL", "OSL", "TL", "RIR", "RBR", "RL"),
  curve.transformation = "None",
  dose_rate,
  temp.lab = "°C",
  cex.global = 1,
  ...
)
}
\arguments{
\item{data}{\linkS4class{Risoe.BINfileData} (\strong{required}):
an S4 object generated by the \link{read_BIN2R} function.}

\item{position}{\link{vector} (\emph{optional}):
option to limit the plotted curves by position
(e.g. \code{position = 1}, \code{position = c(1,3,5)}).}

\item{run}{\link{vector} (\emph{optional}):
option to limit the plotted curves by run
(e.g., \code{run = 1}, \code{run = c(1,3,5)}).}

\item{set}{\link{vector} (\emph{optional}):
option to limit the plotted curves by set
(e.g., \code{set = 1}, \code{set = c(1,3,5)}).}

\item{sorter}{\link{character} (\emph{with default}):
ordering used in plotting the curves, one of "POSITION", "SET" or "RUN".
POSITION, SET and RUN are options defined in the Risoe Sequence Editor.}

\item{ltype}{\link{character} (\emph{with default}):
option to limit the plotted curves by the type of luminescence stimulation.
Allowed values: \code{"IRSL"}, \code{"OSL"},\code{"TL"}, \code{"RIR"}, \code{"RBR"}
(corresponds to LM-OSL), \code{"RL"}.  All type of curves are plotted by
default.}

\item{curve.transformation}{\link{character} (\emph{optional}):
allows transforming CW-OSL and CW-IRSL curves to pseudo-LM curves via
transformation functions. Allowed values are: \code{CW2pLM}, \code{CW2pLMi},
\code{CW2pHMi} and \code{CW2pPMi}, see details. If set to \code{None} (default), no
transformation is applied.}

\item{dose_rate}{\link{numeric} (\emph{optional}):
dose rate of the irradiation source at the measurement date.
If set, the given irradiation dose will be shown in Gy.  See details.}

\item{temp.lab}{\link{character} (\emph{with default}):
the temperature unit to display in the plot labels, by default deg C.}

\item{cex.global}{\link{numeric} (\emph{with default}):
global scaling factor.}

\item{...}{further undocumented plot arguments.}
}
\value{
Returns a plot.
}
\description{
Plots single luminescence curves from a \linkS4class{Risoe.BINfileData} object
produced by \link{read_BIN2R}.
}
\details{
\strong{Nomenclature}

See \linkS4class{Risoe.BINfileData}

\strong{curve.transformation}

This argument allows transforming continuous wave (CW) curves to pseudo
(linear) modulated curves. For the transformation, the functions of the
package are used.  Currently, it is not possible to pass further arguments
to the transformation functions. The argument works only for \code{ltype}
\code{OSL} and \code{IRSL}.

\strong{Irradiation time}

Plotting the irradiation time (s) or the given dose (Gy) requires that the
variable \code{IRR_TIME} has been set within the BIN-file.  This is normally
done by using the 'Run Info' option within the Sequence Editor or by editing
in R.
}
\note{
The function has been successfully tested for the Sequence Editor file
output version 3 and 4.
}
\section{Function version}{
 0.4.3
}

\examples{

##load data
data(ExampleData.BINfileData, envir = environment())

##plot all curves from the first position to the desktop
#pdf(file = "~/Desktop/CurveOutput.pdf", paper = "a4", height = 11, onefile = TRUE)

##example - load from *.bin file
#BINfile<- file.choose()
#BINfileData<-read_BIN2R(BINfile)

#par(mfrow = c(4,3), oma = c(0.5,1,0.5,1))
#plot_Risoe.BINfileData(CWOSL.SAR.Data,position = 1)
#mtext(side = 4, BINfile, outer = TRUE, col = "blue", cex = .7)
#dev.off()

} 

\section{How to cite}{
Kreutzer, S., Dietze, M., Colombo, M., 2025. plot_Risoe.BINfileData(): Plot Single Luminescence Curves from a Risoe.BINfileData-class object. Function version 0.4.3. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.1. https://r-lum.github.io/Luminescence/
}

\references{
Duller, G., 2007. Analyst. pp. 1-45.
}
\seealso{
\linkS4class{Risoe.BINfileData}, \link{read_BIN2R}, \link{convert_CW2pLM},
\link{convert_CW2pLMi}, \link{convert_CW2pPMi}, \link{convert_CW2pHMi}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)\cr
Michael Dietze, GFZ Potsdam (Germany)\cr
Marco Colombo, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{dplot}
