% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R,
%   R/RLum.Analysis-class.R, R/RLum.Data.Curve-class.R
\name{melt_RLum}
\alias{melt_RLum}
\alias{melt_RLum,list-method}
\alias{melt_RLum,RLum.Analysis-method}
\alias{melt_RLum,RLum.Data.Curve-method}
\title{Melt RLum-class objects into a flat data.frame}
\usage{
melt_RLum(object, ...)

\S4method{melt_RLum}{list}(object, ...)

\S4method{melt_RLum}{RLum.Analysis}(object)

\S4method{melt_RLum}{RLum.Data.Curve}(object)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum}}

\item{...}{further arguments passed to the specific class method}
}
\value{
A flat \link{data.frame}.
}
\description{
Melt RLum-class objects into a flat data.frame
}
\section{Functions}{
\itemize{
\item \code{melt_RLum(list)}: Returns a list of melted \linkS4class{RLum} objects; non-RLum objects are silently
removed.

\item \code{melt_RLum(RLum.Analysis)}: Melts \linkS4class{RLum.Analysis} objects into a flat data.frame with columns
\code{X}, \code{Y}, \code{TYPE}, \code{UID}, to be used in combination with other packages
such as \code{ggplot2}.

\item \code{melt_RLum(RLum.Data.Curve)}: Melts \linkS4class{RLum.Data.Curve} objects into a flat data.frame with columns
\code{X}, \code{Y}, \code{TYPE}, \code{UID}, to be used in combination with other packages
such as \code{ggplot2}.

}}
\section{Function version}{
 0.1.0
}

\examples{
data(ExampleData.XSYG, envir = environment())
melt_RLum(OSL.SARMeasurement[[2]][[1]])

}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Analysis}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. melt_RLum(): Melt RLum-class objects into a flat data.frame. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.1. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
