% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Risoe.BINfileData-class.R
\docType{class}
\name{Risoe.BINfileData-class}
\alias{Risoe.BINfileData-class}
\alias{show,Risoe.BINfileData-method}
\alias{set_Risoe.BINfileData,ANY-method}
\alias{get_Risoe.BINfileData,Risoe.BINfileData-method}
\title{Class \code{"Risoe.BINfileData"}}
\usage{
\S4method{show}{Risoe.BINfileData}(object)

\S4method{set_Risoe.BINfileData}{ANY}(
  METADATA = data.frame(),
  DATA = list(),
  .RESERVED = list()
)

\S4method{get_Risoe.BINfileData}{Risoe.BINfileData}(object, ...)
}
\arguments{
\item{object}{an object of class \linkS4class{Risoe.BINfileData}}

\item{METADATA}{Object of class "data.frame" containing the meta information
for each curve.}

\item{DATA}{Object of class "list" containing numeric vector with count data.}

\item{.RESERVED}{Object of class "list" containing list of undocumented raw
values for internal use only.}

\item{...}{other arguments that might be passed}
}
\description{
S4 class object for luminescence data in R. The object is produced as output
of the function \link{read_BIN2R}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show(Risoe.BINfileData)}: Show structure of RLum and Risoe.BINfile class objects

\item \code{set_Risoe.BINfileData(ANY)}: The Risoe.BINfileData is normally produced as output of the function read_BIN2R.
This construction method is intended for internal usage only.

\item \code{get_Risoe.BINfileData(Risoe.BINfileData)}: Formal get-method for Risoe.BINfileData object. It does not allow accessing
the object directly, it is just showing a terminal message.

}}
\section{Slots}{

\describe{
\item{\code{METADATA}}{Object of class "data.frame" containing the meta information for each curve.}

\item{\code{DATA}}{Object of class "list" containing numeric vector with count data.}

\item{\code{.RESERVED}}{Object of class "list" containing list of undocumented raw values for internal use only.}
}}

\note{
\strong{Internal METADATA - object structure}

This structure is compatible with BIN/BINX-files version 03-08, however, it does not follow (in its
sequential arrangement) the manual provided by the manufacturer,
but an own structure accounting for the different versions.

\tabular{rllll}{
\strong{#} \tab \strong{Name} \tab \strong{Data Type} \tab \strong{V} \tab \strong{Description} \cr
\verb{[,1]} \tab \code{ID}  \tab \code{numeric} \tab RLum \tab Unique record ID (same ID as in slot \code{DATA})\cr
\verb{[,2]} \tab \code{SEL} \tab \code{logic} \tab RLum \tab Record selection, not part official BIN-format, triggered by TAG\cr
\verb{[,3]} \tab \code{VERSION} \tab \code{raw} \tab 03-08 \tab BIN-file version number \cr
\verb{[,4]} \tab \code{LENGTH} \tab \code{integer} \tab 03-08 \tab Length of this record\cr
\verb{[,5]} \tab \code{PREVIOUS} \tab \code{integer} \tab 03-08 \tab Length of previous record\cr
\verb{[,6]} \tab \code{NPOINTS} \tab \code{integer} \tab 03-08 \tab Number of data points in the record\cr
\verb{[,7]} \tab \code{RECTYPE} \tab \code{integer} \tab 08 \tab Record type \cr
\verb{[,8]} \tab \code{RUN} \tab \code{integer} \tab 03-08 \tab Run number\cr
\verb{[,9]} \tab \code{SET} \tab \code{integer} \tab 03-08 \tab Set number\cr
\verb{[,10]}  \tab \code{POSITION} \tab  \code{integer} \tab 03-08 \tab Position number\cr
\verb{[,11]} \tab \code{GRAIN} \tab \code{integer} \tab 03-04 \tab Grain number\cr
\verb{[,12]} \tab \code{GRAINNUMBER} \tab \code{integer} \tab 05-08 \tab Grain number\cr
\verb{[,13]} \tab \code{CURVENO} \tab \code{integer} \tab 05-08 \tab Curve number\cr
\verb{[,14]} \tab \code{XCOORD} \tab \code{integer} \tab 03-08 \tab X position of a single grain\cr
\verb{[,15]} \tab \code{YCOORD} \tab \code{integer} \tab 03-08 \tab Y position of a single grain\cr
\verb{[,16]} \tab \code{SAMPLE} \tab \code{factor} \tab 03-08 \tab Sample name\cr
\verb{[,17]} \tab \code{COMMENT} \tab \code{factor} \tab 03-08 \tab Comment name\cr
\verb{[,18]} \tab \code{SYSTEMID} \tab \code{integer} \tab 03-08 \tab Risø system id\cr
\verb{[,19]} \tab \code{FNAME} \tab \code{factor} \tab 05-08 \tab File name (\emph{.bin/}.binx)\cr
\verb{[,20]} \tab \code{USER} \tab \code{factor} \tab 03-08 \tab User name\cr
\verb{[,21]} \tab \code{TIME} \tab \code{character} \tab 03-08 \tab Data collection time (\code{hh-mm-ss})\cr
\verb{[,22]} \tab \code{DATE} \tab \code{factor} \tab 03-08 \tab Data collection date (\code{ddmmyy})\cr
\verb{[,23]} \tab \code{DTYPE} \tab \code{character} \tab 03-08 \tab Data type\cr
\verb{[,24]} \tab \code{BL_TIME} \tab \code{numeric} \tab 03-08 \tab Bleaching time\cr
\verb{[,25]} \tab \code{BL_UNIT} \tab \code{integer} \tab 03-08 \tab Bleaching unit (mJ, J, s, min, h)\cr
\verb{[,26]} \tab \code{NORM1} \tab \code{numeric} \tab 03-08 \tab Normalisation factor (1)\cr
\verb{[,27]} \tab \code{NORM2} \tab \code{numeric} \tab 03-08 \tab Normalisation factor (2)\cr
\verb{[,28]} \tab \code{NORM3} \tab \code{numeric} \tab 03-08 \tab Normalisation factor (3)\cr
\verb{[,29]} \tab \code{BG} \tab \code{numeric} \tab 03-08 \tab Background level\cr
\verb{[,30]} \tab \code{SHIFT} \tab \code{integer} \tab 03-08 \tab Number of channels to shift data\cr
\verb{[,31]} \tab \code{TAG} \tab \code{integer} \tab 03-08 \tab Tag, triggers \code{SEL}\cr
\verb{[,32]} \tab \code{LTYPE} \tab \code{character} \tab 03-08 \tab Luminescence type\cr
\verb{[,33]} \tab \code{LIGHTSOURCE} \tab \code{character} \tab 03-08 \tab Light source\cr
\verb{[,34]} \tab \code{LPOWER} \tab \code{numeric} \tab 03-08 \tab Optical stimulation power\cr
\verb{[,35]} \tab \code{LIGHTPOWER} \tab \code{numeric} \tab 05-08 \tab Optical stimulation power\cr
\verb{[,36]} \tab \code{LOW} \tab \code{numeric} \tab 03-08 \tab Low (temperature, time, wavelength)\cr
\verb{[,37]} \tab \code{HIGH} \tab \code{numeric} \tab 03-08 \tab High (temperature, time, wavelength)\cr
\verb{[,38]} \tab \code{RATE} \tab \code{numeric} \tab 03-08 \tab Rate (heating rate, scan rate)\cr
\verb{[,39]} \tab \code{TEMPERATURE} \tab \code{integer} \tab 03-08 \tab Sample temperature\cr
\verb{[,40]} \tab \code{MEASTEMP} \tab \code{integer} \tab 05-08 \tab Measured temperature\cr
\verb{[,41]} \tab \code{AN_TEMP} \tab \code{numeric} \tab 03-08 \tab Annealing temperature\cr
\verb{[,42]} \tab \code{AN_TIME} \tab \code{numeric} \tab 03-08 \tab Annealing time\cr
\verb{[,43]} \tab \code{TOLDELAY} \tab \code{integer} \tab 03-08 \tab TOL 'delay' channels\cr
\verb{[,44]} \tab \code{TOLON} \tab \code{integer} \tab 03-08 \tab TOL 'on' channels\cr
\verb{[,45]} \tab \code{TOLOFF} \tab \code{integer} \tab 03-08 \tab TOL 'off' channels\cr
\verb{[,46]} \tab \code{IRR_TIME} \tab \code{numeric} \tab 03-08 \tab Irradiation time\cr
\verb{[,47]} \tab \code{IRR_TYPE} \tab \code{integer} \tab 03-08 \tab Irradiation type (alpha, beta or gamma)\cr
\verb{[,48]} \tab \code{IRR_UNIT} \tab \code{integer} \tab 03-04 \tab Irradiation unit (Gy, rad, s, min, h)\cr
\verb{[,49]} \tab \code{IRR_DOSERATE} \tab \code{numeric} \tab 05-08 \tab Irradiation dose rate (Gy/s)\cr
\verb{[,50]} \tab \code{IRR_DOSERATEERR} \tab \code{numeric} \tab 06-08 \tab Irradiation dose rate error (Gy/s)\cr
\verb{[,51]} \tab \code{TIMESINCEIRR} \tab \code{integer} \tab 05-08 \tab Time since irradiation (s)\cr
\verb{[,52]} \tab \code{TIMETICK} \tab \code{numeric} \tab 05-08 \tab Time tick for pulsing (s)\cr
\verb{[,53]} \tab \code{ONTIME} \tab \code{integer} \tab 05-08 \tab On-time for pulsing (in time ticks)\cr
\verb{[,54]} \tab \code{OFFTIME} \tab \code{integer} \tab 03 \tab Off-time for pulsed stimulation (in s) \cr
\verb{[,55]} \tab \code{STIMPERIOD} \tab \code{integer} \tab 05-08 \tab Stimulation period (on+off in time ticks)\cr
\verb{[,56]} \tab \code{GATE_ENABLED} \tab \code{raw} \tab 05-08 \tab PMT signal gating enabled\cr
\verb{[,57]} \tab \code{ENABLE_FLAGS} \tab \code{raw} \tab 05-08 \tab PMT signal gating  enabled\cr
\verb{[,58]} \tab \code{GATE_START} \tab \code{integer} \tab 05-08 \tab Start gating (in time ticks)\cr
\verb{[,59]} \tab \code{GATE_STOP} \tab \code{integer} \tab 05-08 \tab Stop gating (in time ticks), \code{'Gateend'} for version 04, here only GATE_STOP is used\cr
\verb{[,60]} \tab \code{PTENABLED} \tab \code{raw} \tab 05-08 \tab Photon time enabled\cr
\verb{[,61]} \tab \code{DTENABLED} \tab \code{raw} \tab 05-08 \tab PMT dead time correction enabled\cr
\verb{[,62]} \tab \code{DEADTIME} \tab \code{numeric} \tab 05-08 \tab PMT dead time (s)\cr
\verb{[,63]} \tab \code{MAXLPOWER} \tab \code{numeric} \tab 05-08 \tab Stimulation power to 100 percent (mW/cm^2)\cr
\verb{[,64]} \tab \code{XRF_ACQTIME} \tab \code{numeric} \tab 05-08 \tab XRF acquisition time (s)\cr
\verb{[,65]} \tab \code{XRF_HV} \tab \code{numeric} \tab 05-08 \tab XRF X-ray high voltage (V)\cr
\verb{[,66]} \tab \code{XRF_CURR} \tab \code{integer} \tab 05-08 \tab XRF X-ray current (µA)\cr
\verb{[,67]} \tab \code{XRF_DEADTIMEF} \tab \code{numeric} \tab 05-08 \tab XRF dead time fraction\cr
\verb{[,68]} \tab \code{DETECTOR_ID} \tab \code{raw} \tab 07-08 \tab Detector ID\cr
\verb{[,69]} \tab \code{LOWERFILTER_ID} \tab \code{integer} \tab 07-08 \tab Lower filter ID in reader\cr
\verb{[,70]} \tab \code{UPPERFILTER_ID} \tab \code{integer} \tab 07-08 \tab Upper filter ID in reader\cr
\verb{[,71]} \tab \code{ENOISEFACTOR} \tab \code{numeric} \tab 07-08 \tab Excess noise filter, usage unknown \cr
\verb{[,72]} \tab \code{MARKPOS_X1} \tab \code{numeric} \tab 08 \tab Coordinates marker position 1 \cr
\verb{[,73]} \tab \code{MARKPOS_Y1} \tab \code{numeric} \tab 08 \tab Coordinates marker position 1 \cr
\verb{[,74]} \tab \code{MARKPOS_X2} \tab \code{numeric} \tab 08 \tab Coordinates marker position 2 \cr
\verb{[,75]} \tab \code{MARKPOS_Y2} \tab \code{numeric} \tab 08 \tab Coordinates marker position 2 \cr
\verb{[,76]} \tab \code{MARKPOS_X3} \tab \code{numeric} \tab 08 \tab Coordinates marker position 3 \cr
\verb{[,77]} \tab \code{MARKPOS_Y3} \tab \code{numeric} \tab 08 \tab Coordinates marker position 3 \cr
\verb{[,78]} \tab \code{EXTR_START} \tab \code{numeric} \tab 08 \tab usage unknown \cr
\verb{[,79]} \tab \code{EXTR_END} \tab \code{numeric} \tab 08 \tab usage unknown\cr
\verb{[,80]} \tab \code{SEQUENCE} \tab \code{character} \tab 03-04 \tab Sequence name
}
V = BIN-file version (RLum means that it does not depend on a specific BIN version)

Note that the \code{Risoe.BINfileData} object combines all values from
different versions from the BIN-file, reserved bits are skipped, however,
the function \link{write_R2BIN} reset arbitrary reserved bits. Invalid
values for a specific version are set to \code{NA}. Furthermore, the
internal R data types do not necessarily match the required data types for
the BIN-file data import! Data types are converted during data import.\cr

\strong{LTYPE} values

\tabular{rll}{
VALUE \tab TYPE \tab DESCRIPTION \cr
\verb{[0]} \tab \code{TL} \tab: Thermoluminescence \cr
\verb{[1]} \tab \code{OSL} \tab: Optically stimulated luminescence \cr
\verb{[2]} \tab \code{IRSL} \tab: Infrared stimulated luminescence \cr
\verb{[3]} \tab \code{M-IR} \tab: Infrared monochromator scan\cr
\verb{[4]} \tab \code{M-VIS} \tab: Visible monochromator scan\cr
\verb{[5]} \tab \code{TOL} \tab: Thermo-optical luminescence \cr
\verb{[6]} \tab \code{TRPOSL} \tab: Time Resolved Pulsed OSL\cr
\verb{[7]} \tab \code{RIR} \tab: Ramped IRSL\cr
\verb{[8]} \tab \code{RBR} \tab: Ramped (Blue) LEDs\cr
\verb{[9]} \tab \code{USER} \tab: User defined\cr
\verb{[10]} \tab \code{POSL} \tab: Pulsed OSL \cr
\verb{[11]} \tab \code{SGOSL} \tab: Single Grain OSL\cr
\verb{[12]} \tab \code{RL} \tab: Radio Luminescence \cr
\verb{[13]} \tab \code{XRF} \tab: X-ray Fluorescence
}

\strong{DTYPE} values

\tabular{rl}{
VALUE \tab DESCRIPTION \cr
\verb{[0]} \tab Natural \cr
\verb{[1]} \tab N+dose \cr
\verb{[2]} \tab Bleach \cr
\verb{[3]} \tab Bleach+dose \cr
\verb{[4]} \tab Natural (Bleach) \cr
\verb{[5]} \tab N+dose (Bleach) \cr
\verb{[6]} \tab Dose \cr
\verb{[7]} \tab Background
}

\strong{LIGHTSOURCE} values

\tabular{rl}{
VALUE \tab DESCRIPTION \cr
\verb{[0]} \tab None \cr
\verb{[1]} \tab Lamp \cr
\verb{[2]} \tab IR diodes/IR Laser \cr
\verb{[3]} \tab Calibration LED \cr
\verb{[4]} \tab Blue Diodes \cr
\verb{[5]} \tab White light \cr
\verb{[6]} \tab Green laser (single grain) \cr
\verb{[7]} \tab IR laser (single grain) }

\strong{Internal DATA - object structure}

With version 8 of the BIN/BINX file format, slot \verb{@DATA} (byte array \code{DPOINTS}) can
contain two different values:
\enumerate{
\item \code{DPOINTS} (standard for \code{RECTYPE} := (0,1)): is a vector with the length defined
through \code{NPOINTS}. This is the standard for xy-curves since version 03.
\item \code{DPOINTS} (\code{RECTYPE} := 128) is contains no count values but information about
the definition of the regions of interest (ROI). Each definition is 504 bytes long.
The number of definitions is defined by \code{NPOINTS} in \verb{@METADATA}. The record
describes basically the geometric features of the regions of interest.
The representation in R is a nested \link{list}.
}

\tabular{rllll}{
\strong{#} \tab \strong{Name} \tab \strong{Data Type} \tab \strong{V} \tab \strong{Description} \cr
\verb{[,1]} \tab \code{NOFPOINTS}  \tab \code{numeric} \tab 08 \tab number of points in the definition (e.g., if the ROI is a rectangle: 4)\cr
\verb{[,2]} \tab \code{USEDFOR}  \tab \code{logical} \tab 08 \tab samples for which the ROI is used for; a maximum of 48 samples are allowed.\cr
\verb{[,3]} \tab \code{SHOWNFOR}  \tab \code{logical} \tab 08 \tab samples for which the ROI is shown for; a maximum of 48 samples are allowed.\cr
\verb{[,4]} \tab \code{COLOR}  \tab \code{numeric} \tab 08 \tab The colour values of the ROI.\cr
\verb{[,5]} \tab \code{X}  \tab \code{numeric} \tab 08 \tab The x coordinates used to draw the ROI geometry (up to 50 points are allowed).\cr
\verb{[,6]} \tab \code{Y}  \tab \code{numeric} \tab 08 \tab The y coordinates used to draw the ROI geometry (up to 50 points are allowed).\cr
}

(information on the BIN/BINX file format are kindly provided by Risø, DTU Nutech)
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("Risoe.BINfileData", ...)}.
}

\section{Function version}{
 0.4.1
}

\examples{

showClass("Risoe.BINfileData")

} 

\section{How to cite}{
Kreutzer, S., 2024. Risoe.BINfileData-class(): Class 'Risoe.BINfileData'. Function version 0.4.1. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., 2024. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.26. https://r-lum.github.io/Luminescence/
}

\references{
Risø DTU, 2013. The Sequence Editor User Manual - Feb 2013 and Risø DTU, 2016.

The Sequence Editor User Manual - February 2016

\url{https://www.fysik.dtu.dk}
}
\seealso{
\link{plot_Risoe.BINfileData}, \link{read_BIN2R}, \link{write_R2BIN},
\link{merge_Risoe.BINfileData}, \link{Risoe.BINfileData2RLum.Analysis}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)\cr
based on information provided by Torben Lapp and Karsten Bracht Nielsen (Risø DTU, Denmark)
, RLum Developer Team}
\keyword{classes}
\keyword{internal}
