% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_Data.R
\name{tune_Data}
\alias{tune_Data}
\title{Tune data for experimental purpose}
\usage{
tune_Data(data, decrease.error = 0, increase.data = 0)
}
\arguments{
\item{data}{\link{data.frame} (\strong{required}):
input values, structure: data (\code{values[,1]}) and data error (\code{values [,2]})
are required}

\item{decrease.error}{\link{numeric}:
factor by which the error is decreased, ranges between 0 and 1.}

\item{increase.data}{\link{numeric}:
factor by which the error is decreased, ranges between 0 and \code{Inf}.}
}
\value{
Returns a \link{data.frame} with tuned values.
}
\description{
The error can be reduced and sample size increased for specific purpose.
}
\note{
You should not use this function to improve your poor data set!
}
\section{Function version}{
 0.5.0
}

\examples{

## load example data set
data(ExampleData.DeValues, envir = environment())
x <- ExampleData.DeValues$CA1

## plot original data
plot_AbanicoPlot(data = x,
                 summary = c("n", "mean"))

## decrease error by 10 \%
plot_AbanicoPlot(data = tune_Data(x, decrease.error = 0.1),
                 summary = c("n", "mean"))

## increase sample size by 200 \%
#plot_AbanicoPlot(data = tune_Data(x, increase.data = 2) ,
#                summary = c("n", "mean"))

}
\author{
Michael Dietze, GFZ Potsdam (Germany)
, RLum Developer Team} 

\section{How to cite}{
Dietze, M., 2022. tune_Data(): Tune data for experimental purpose. Function version 0.5.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2022. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.17. https://CRAN.R-project.org/package=Luminescence
}

\keyword{manip}
