% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_WodaFuchs2008.R
\name{calc_WodaFuchs2008}
\alias{calc_WodaFuchs2008}
\title{Obtain the equivalent dose using the approach by Woda and Fuchs 2008}
\usage{
calc_WodaFuchs2008(data, breaks = NULL, plot = TRUE, ...)
}
\arguments{
\item{data}{\link{data.frame} or \linkS4class{RLum.Results} object (\strong{required}):
for \link{data.frame}: two columns: De (\code{values[,1]}) and De error (\code{values[,2]}).
For plotting multiple data sets, these must be provided as \code{list}
(e.g. \code{list(dataset1, dataset2)}).}

\item{breaks}{\link{numeric}:
Either number or locations of breaks. See \code{[hist]} for details.
If missing, the number of breaks will be estimated based on the bin width
(as function of median error).}

\item{plot}{\link{logical} (\emph{with default}):
enable plot output.}

\item{...}{Further plot arguments passed to the function.}
}
\description{
The function generates a histogram-like reorganisation of the data, to
assess counts per bin. The log-transformed counts per bin are used to
calculate the second derivative of the data (i.e., the curvature of the
curve) and to find the central value of the bin hosting the distribution
maximum. A normal distribution model is fitted to the counts per bin
data to estimate the dose distribution parameters. The uncertainty of the
model is estimated based on all input equivalent doses smaller that of the
modelled central value.
}
\section{Function version}{
 0.2.0 (2018-02-08 14:24:10)
}

\examples{

## read example data set
data(ExampleData.DeValues, envir = environment())

results <- calc_WodaFuchs2008(
  data = ExampleData.DeValues$CA1,
   xlab = expression(paste(D[e], " [Gy]"))
 )

} 

\section{How to cite}{
Kreutzer, S., Dietze, M. (2018). calc_WodaFuchs2008(): Obtain the equivalent dose using the approach by Woda and Fuchs 2008. Function version 0.2.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2018). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.8.2. https://CRAN.R-project.org/package=Luminescence
}

\references{
Woda, C., Fuchs, M., 2008. On the applicability of the leading edge method to
obtain equivalent doses in OSL dating and dosimetry. Radiation Measurements 43, 26-37.
}
\seealso{
\link{calc_FuchsLang2001}, \link{calc_CentralDose}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France),\cr
Michael Dietze, GFZ Potsdam (Germany)
\cr R Luminescence Package Team}
