% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano_master.R
\name{volcano}
\alias{volcano}
\title{Generate Volcano Plot}
\usage{
volcano(
  data,
  x.scale,
  y.scale,
  interact = FALSE,
  FC.threshold = 2,
  P.threshold = 0.05,
  change.label = c("Up", "Down", "Notsig"),
  point.size = 2,
  point.color = c("lightsalmon2", "cadetblue", "grey"),
  x_scale_mannual = FALSE,
  y_scale_mannual = FALSE,
  linetype = 4,
  line.alpha = 0.4,
  line.color = "grey34",
  line.size = 1,
  annotation = FALSE,
  text.size = 2.5,
  max.overlap = 40,
  title = NULL
)
}
\arguments{
\item{data}{The data frame containing the results of differential expression analysis.}

\item{x.scale}{The manual limits for the x-axis (default is NULL).}

\item{y.scale}{The manual limits for the y-axis (default is NULL).}

\item{interact}{Logical value indicating whteher to generate interactive volcano plot.}

\item{FC.threshold}{The fold change threshold for determining significant changes (default is 2).}

\item{P.threshold}{The significance threshold for p-values (default is 0.05).}

\item{change.label}{The labels for differentially expressed genes (default is c('Up', 'Down', 'Notsig')).}

\item{point.size}{The size of data points in the plot (default is 2).}

\item{point.color}{The colors for differentially expressed genes (default is c('lightsalmon2', 'cadetblue', 'grey')).}

\item{x_scale_mannual}{Logical value indicating whether to manually specify x-axis limits (default is FALSE).}

\item{y_scale_mannual}{Logical value indicating whether to manually specify y-axis limits (default is FALSE).}

\item{linetype}{The line type for significance thresholds (default is 4).}

\item{line.alpha}{The transparency level for significance thresholds (default is 0.4).}

\item{line.color}{The color for significance thresholds (default is 'grey34').}

\item{line.size}{The size of significance thresholds (default is 1).}

\item{annotation}{Logical value indicating whether to add gene labels to the plot (default is FALSE).}

\item{text.size}{The size of gene labels (default is 1.5).}

\item{max.overlap}{The maximum number of overlapping labels allowed (default is 40).}

\item{title}{The title for the plot (default is NULL).}
}
\value{
A list containing the plot object, data frame with plotted points, and omitted data points.
}
\description{
This function generates a volcano plot for differential expression analysis results.
}
