% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additionalFunctions.R
\name{plotLipids}
\alias{plotLipids}
\title{Plot informative peaks for lipids annotation}
\usage{
plotLipids(msobject, spar = 0.4)
}
\arguments{
\item{msobject}{annotated msobject.}

\item{spar}{smoothing parameter. Numeric value between 0 and 1.}
}
\value{
msobject with a plots element which contains a list of plots.
Plots on the left side represent raw values while plots on the left side are
smoothed or clean scans (MS2 in DDA).
}
\description{
Plot informative peaks for each lipid annotated using idPOS and idNEG (or
similar functions).
}
\details{
Peak intensities are relative to the maximum intensity of each peak
to ease visualization.
}
\examples{
\dontrun{
devtools::install_github("maialba3/LipidMSdata2")

library(LipidMS)
msobject <- idPOS(LipidMSdata2::msobjectDIApos)
msobject <- plotLipids(msobject)

# display the first plot
msobject$plots[[1]]
msobject$plots[["peakID"]]

# save all plot to a pdf file
pdf("plotresults.pdf")
msobject$plots
dev.off()
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
