% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idFunctionsPos.R
\name{idPGpos}
\alias{idPGpos}
\title{Phosphoglycerols (PG) annotation for ESI+}
\usage{
idPGpos(
  msobject,
  ppm_precursor = 5,
  ppm_products = 10,
  rttol = 3,
  rt,
  adducts = c("M+H", "M+NH4", "M+Na"),
  clfrags = c("dg_M+H-H2O"),
  clrequired = c(F),
  ftype = c("BB"),
  chainfrags_sn1 = c("mg_M+H-H2O"),
  chainfrags_sn2 = c("mg_M+H-H2O"),
  intrules = c("mg_sn1/mg_sn2"),
  rates = c("1/2"),
  intrequired = c(F, F),
  coelCutoff = 0.8,
  dbs
)
}
\arguments{
\item{msobject}{an msobject returned by \link{dataProcessing}.}

\item{ppm_precursor}{mass tolerance for precursor ions. By default, 5 ppm.}

\item{ppm_products}{mass tolerance for product ions. By default, 10 ppm.}

\item{rttol}{total rt window for coelution between precursor and product
ions. By default, 3 seconds.}

\item{rt}{rt range where the function will look for candidates. By default,
it will search within all RT range in MS1.}

\item{adducts}{expected adducts for PE in ESI+. Adducts allowed can
be modified in adductsTable (dbs argument).}

\item{clfrags}{vector containing the expected fragments for a given lipid
class. See \link{checkClass} for details.}

\item{clrequired}{logical vector indicating if each class fragment is
required or not. If any of them is required, at least one of them must be
present within the coeluting fragments. See \link{checkClass} for details.}

\item{ftype}{character vector indicating the type of fragments in clfrags.
It can be: "F" (fragment), "NL" (neutral loss) or "BB" (building block).
See \link{checkClass} for details.}

\item{chainfrags_sn1}{character vector containing the fragmentation rules for
the chain fragments in sn1 position. See \link{chainFrags} for details.}

\item{chainfrags_sn2}{character vector containing the fragmentation rules for
the chain fragments in sn2 position. See \link{chainFrags} for details. If
empty, it will be estimated based on the difference between precursors and
sn1 chains.}

\item{intrules}{character vector specifying the fragments to compare. See
\link{checkIntensityRules}.}

\item{rates}{character vector with the expected rates between fragments given
as a string (e.g. "3/1"). See \link{checkIntensityRules}.}

\item{intrequired}{logical vector indicating if any of the rules is required.
If not, at least one must be verified to confirm the structure.}

\item{coelCutoff}{coelution score threshold between parent and fragment ions.
Only applied if rawData info is supplied. By default, 0.8.}

\item{dbs}{list of data bases required for annotation. By default, dbs
contains the required data frames based on the default fragmentation rules.
If these rules are modified, dbs may need to be supplied. See
\link{createLipidDB} and \link{assignDB}.}
}
\value{
annotated msobject (list with several elements). The results element
is a data frame that shows: ID, class of lipid, CDB (total number of carbons
and double bounds), FA composition (specific chains composition if it has
been confirmed), m.z, RT (in seconds), I (intensity), Adducts, ppm (m.z error),
confidenceLevel (Subclass, FA level, where chains are known but not their
positions, or FA position level), peakID, and PFCS (parent-fragment coelution
score mean of all fragments used for the identification); and the
annotatedPeaklist element shows the original MS1 peaklist with the annotations
on it.
}
\description{
PG identification based on fragmentation patterns for LC-MS/MS DIA or DDA
data acquired in positive mode.
}
\details{
\code{idPGpos} function involves 5 steps. 1) FullMS-based
identification of candidate PG as M+H, M+NH4 and M+Na. 2) Search of PG class
fragments: loss of head group (DG as M+H-H2O) coeluting with the precursor
ion. 3) Search of specific fragments that inform about chain composition at
sn1 (MG as M+H-H2O resulting from the loss of the FA chain at sn2)
and sn2 (MG as M+H-H2O resulting from the loss of the FA chain at sn1).
4) Look for possible chains structure based on the combination of chain
fragments. 5) Check intensity rules to confirm chains position. MG from sn1
is at least 2 times more intense than the ones from sn2.

Results data frame shows: ID, class of lipid, CDB (total number
of carbons and double bounds), FA composition (specific chains composition if
it has been confirmed), mz, RT (in seconds), I (intensity, which comes
directly from de input), Adducts, ppm (m.z error), confidenceLevel (Subclass,
FA level, where chains are known but not their positions, or FA position
level) and PFCS (parent-fragment coelution score mean of all fragments used
for the identification).
}
\note{
This function has been writen based on fragmentation patterns
observed for three different platforms (QTOF 6550 from Agilent, Sinapt G2-Si
from Waters and Q-exactive from Thermo), but it may need to be customized for
other platforms or acquisition settings.
}
\examples{
\dontrun{
devtools::install_github("maialba3/LipidMSdata2")

library(LipidMS)
msobject <- idPGpos(LipidMSdata2::msobjectDIApos)
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
