% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TLindley.R
\name{TLindley}
\alias{TLindley}
\alias{dtlindley}
\alias{htlindley}
\alias{ptlindley}
\alias{qtlindley}
\alias{rtlindley}
\title{Transmuted Lindley Distribution}
\source{
[dpqh]tlindley are calculated directly from the definitions. \code{rtlindley} uses the inverse transform method.
}
\usage{
dtlindley(x, theta, alpha, log = FALSE)

ptlindley(q, theta, alpha, lower.tail = TRUE, log.p = FALSE)

qtlindley(p, theta, alpha, lower.tail = TRUE, log.p = FALSE, L = 1e-04,
  U = 50)

rtlindley(n, theta, alpha, L = 1e-04, U = 50)

htlindley(x, theta, alpha, log = FALSE)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{theta}{positive parameter.}

\item{alpha}{\eqn{-1 \leq \alpha \leq +1}.}

\item{log, log.p}{logical. If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical. If TRUE (default) \eqn{P(X \leq x)} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{L, U}{interval which \code{uniroot} searches for a root (quantile), L = 1e-4 and U = 50 are the default values.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dtlindley} gives the density, \code{ptlindley} gives the distribution function, \code{qtlindley} gives the quantile function, \code{rtlindley} generates random deviates and \code{htlindley} gives the hazard rate function.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function, random numbers generation and hazard rate function for the transmuted Lindley distribution with parameters theta and alpha.
}
\details{
Probability density function
\deqn{f(x\mid \theta ,\alpha )={\frac{{\theta }^{2}\left( 1+x\right) e{^{-\theta x}}}{1+\theta }\left[ 1-\alpha +2\alpha \left( 1+{\frac{\theta x}{1+\theta }}\right) e{^{-\theta x}}\right] }}

Cumulative distribution function
\deqn{F(x\mid \theta ,\alpha )=\left( 1+\alpha \right) \left[ 1-\left( 1+{\frac{\theta x}{1+\theta }}\right) e{^{-\theta x}}\right] -\alpha \left[1-\left( 1+{\frac{\theta x}{1+\theta }}\right) e{^{-\theta x}}\right]^{2}}

Quantile function
\deqn{\code{does not have a closed mathematical expression}}

Hazard rate function
\deqn{h(x\mid \theta ,\alpha )={\frac{{\theta }^{2}\left( 1+x\right) e{^{-\theta x}\left[ 1-\alpha +2\alpha \left( 1+{\frac{\theta x}{1+\theta }} \right) e{^{-\theta x}}\right] }}{\left( 1+\theta \right) \left\{ \left( 1+\alpha \right) \left[ 1-\left( 1+{\frac{\theta x}{1+\theta }}\right) e{^{-\theta x}}\right] -\alpha \left[ 1-\left( 1+{\frac{\theta x}{1+\theta }}\right) e{^{-\theta x}}\right] ^{2}\right\} }}}

\bold{Particular case:} \eqn{\alpha = 0} the one-parameter Lindley distribution.
}
\note{
The \code{\link[stats]{uniroot}} function with default arguments is used to find out the quantiles.
}
\examples{
set.seed(1)
x <- rtlindley(n = 1000, theta = 1.5, alpha = 0.5)
R <- range(x)
S <- seq(from = R[1], to = R[2], by = 0.1)
plot(S, dtlindley(S, theta = 1.5, alpha = 0.5), xlab = 'x', ylab = 'pdf')
hist(x, prob = TRUE, main = '', add = TRUE)

p <- seq(from = 0.1, to = 0.9, by = 0.1)
q <- quantile(x, prob = p)
ptlindley(q, theta = 1.5, alpha = 0.5, lower.tail = TRUE)
ptlindley(q, theta = 1.5, alpha = 0.5, lower.tail = FALSE)
qtlindley(p, theta = 1.5, alpha = 0.5, lower.tail = TRUE)
qtlindley(p, theta = 1.5, alpha = 0.5, lower.tail = FALSE)

library(fitdistrplus)
fit <- fitdist(x, 'tlindley', start = list(theta = 1.5, alpha = 0.5))
plot(fit)


}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Larissa B. Fernandes \email{lbf.estatistica@gmail.com}
}
\references{
Merovci, F., (2013). Transmuted Lindley distribution. \emph{International Journal of Open Problems in Computer Science and Mathematics}, \bold{63}, (3), 63-72.
}
\seealso{
\code{\link[stats]{uniroot}}.
}

