% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.lw.net.R
\name{calc.lw.net}
\alias{calc.lw.net}
\alias{calc.lw.net.base}
\title{Estimate net long wave heat radiation}
\usage{
calc.lw.net(ts.data, lat, atm.press)

calc.lw.net.base(dateTime, sw, Ts, lat, atm.press, airT, RH)
}
\arguments{
\item{ts.data}{Object of class \code{data.frame} including the required variables(see details for list of variables and their units)}

\item{lat}{latitude in degrees north}

\item{atm.press}{atmospheric pressure in mb}

\item{dateTime}{vector of datetime in POSIXct format}

\item{sw}{numeric value of short wave radiation, W/m2}

\item{Ts}{numeric value of surface water temperature, degC}

\item{airT}{numeric value of air temperature, degC}

\item{RH}{numeric value of relative humidity, \%}
}
\value{
## for calc.lw.net.base

A numeric value of net long wave heat flux in W/m^2

## for calc.lw.net

A data.frame with columns \code{datetime} and \code{lwnet} in W/m^2
}
\description{
Returns the net long wave radiation based on Crawford and Duchon, 1999.
}
\examples{

## Base example
dateTime <- as.POSIXct("2013-12-30 23:00")
Uz <- 3
airT <- 20
RH <- 90
sw <- 800
wndZ <- 2
Kd <- 2
lat <- 54
lake.area <- 5000 
atm.press <- 1013
Ts <- 22
calc.lw.net.base(dateTime,sw,Ts,lat,atm.press,airT,RH)

## Example using timeseries in a data frame
data.path = system.file('extdata', package="LakeMetabolizer")

sp.data = load.all.data('sparkling', data.path)

# Prep the input data
ts.data	= sp.data$data #pull out just the timeseries data
atm.press	= 1018
lat	= sp.data$metadata$latitude

lwnet = calc.lw.net(ts.data, lat, atm.press)
plot(lwnet$datetime, lwnet$lwnet)

}
\author{
R Iestyn Woolway
Jordan S. Read
Hilary Dugan
Luke Winslow
}
\references{
Crawford, T.M., and Duchon, C.E. 1999. \emph{An improved parameterization for 
estimating effective atmospheric emissivity for use in calculating daytime 
downwelling longwave radiation}. Journal of Applied Meteorology 38: 474-480.
}
\seealso{
\code{\link{k.read}} and \code{\link{k.macIntyre}}
}
\keyword{math}
\keyword{methods}

