% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helper_functions.R
\name{convert_age_to_cir}
\alias{convert_age_to_cir}
\title{Convert age to cumulative incidence rate}
\usage{
convert_age_to_cir(age, pop_prev = 0.1, mid_point = 60, slope = 1/8)
}
\arguments{
\item{age}{A non-negative number representing the individual's age.}

\item{pop_prev}{A positive number representing the overall
population prevalence. Must be at most 1. Defaults to 0.1.}

\item{mid_point}{A positive number representing the mid point
logistic function. Defaults to 60.}

\item{slope}{A number holding the rate of increase.
Defaults to 1/8.}
}
\value{
If age and mid_point are positive numbers, if pop_prev
is a positive number between 0 and 1 and if slope is a valid number,
then \code{convert_age_to_cir} returns a number, which is equal to
the cumulative incidence rate.
}
\description{
\code{convert_age_to_cir} computes the cumulative incidence
rate from a person's age.
}
\details{
Given a person's age, \code{convert_age_to_cir} can be used
to compute the cumulative incidence rate (cir), which is given
by the formula
\deqn{pop\_ prev / (1 + exp((mid\_ point - age) * slope))}
}
\examples{
curve(sapply(age, convert_age_to_cir), from = 10, to = 110, xname = "age")
}
