% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table_history.R
\name{get_table_history}
\alias{get_table_history}
\title{Stratify Person Table with Time Varying Co-variate}
\usage{
get_table_history(
  persondf,
  rateobj,
  historydf,
  exps = list(),
  strata = dplyr::vars(),
  batch_size = 500
)
}
\arguments{
\item{persondf}{data.frame like object containing one row per person with the required demographic information.}

\item{rateobj}{a rate object created by the \code{parseRate} function, or the included rate object \code{us_119ucod_19602021}.}

\item{historydf}{data.frame like object containing one row per person and exposure period. An exposure period is a
period of time where exposure levels remain constant. See \code{Details} for required variables.}

\item{exps}{a list containing exp_strata objects created by \code{exp_strata()}.}

\item{strata}{any additional variables contained in persondf on which to stratify.
Must be wrapped in a \code{vars()} call from \code{dplyr}.}

\item{batch_size}{a number specifying how many persons to stratify at a time. Default is 500.}
}
\value{
A data.frame with a row for each strata containing the number of observed
deaths within each of the defined minors/outcomes (\verb{_o1}-\verb{_oxxx}) and the number of person days.
}
\description{
\code{get_table_history} reads in a data.frame/tibble (\code{persondf}) containing basic demographic information for
each person of the cohort as well as a data.frame/tibble (\code{historydf}) containing time varying exposure
information and stratifies the person-time and deaths into 5-year age, 5-year calendar period, race, sex and
exposure categories. See \code{Details} for information on how the person file and history file must be
formatted.
}
\details{
The persondf tibble must contain the variables:
\itemize{
\item id,
\item gender (character: 'M'/'F'),
\item race (character: 'W'/'N'),
\item dob (date),
\item pybegin (date),
\item dlo	(date),
\item rev (numeric: values 5-10),
\item code (character: ICD code)
}

The historydf tibble must contain the variables:
\itemize{
\item id,
\item begin_dt (date),
\item end_dt (date),
\item \emph{<daily exposure levels>}
}
}
\examples{
library(LTASR)
library(dplyr)

#Import example person file
person <- person_example \%>\%
mutate(dob = as.Date(dob, format='\%m/\%d/\%Y'),
         pybegin = as.Date(pybegin, format='\%m/\%d/\%Y'),
         dlo = as.Date(dlo, format='\%m/\%d/\%Y'))

#Import example history file
history <- history_example \%>\%
  mutate(begin_dt = as.Date(begin_dt, format='\%m/\%d/\%Y'),
         end_dt = as.Date(end_dt, format='\%m/\%d/\%Y'))

#Import default rate object
rateobj <- us_119ucod_19602021

#Define exposure of interest. Create exp_strata object.The `employed` variable
#indicates (0/1) periods of employment and will be summed each day of each exposure
#period. Therefore, this calculates duration of employment in days. The cut-points
#used below will stratify by person-time with less than and greater than a
#year of employment (365 days of employment).
exp1 <- exp_strata(var = 'employed',
                   cutpt = c(-Inf, 365, Inf),
                   lag = 0)

#Stratify cohort by employed variable.
py_table <- get_table_history(persondf = person,
                              rateobj = rateobj,
                              historydf = history,
                              exps = list(exp1))

#Multiple exposures can be considered.
exp1 <- exp_strata(var = 'employed',
                   cutpt = c(-Inf, 365, Inf),
                   lag = 0)
exp2 <- exp_strata(var = 'exposure_level',
                   cutpt = c(-Inf, 0, 10000, 20000, Inf),
                   lag = 10)

#Stratify cohort by employed variable.
py_table <- get_table_history(persondf = person,
                              rateobj = rateobj,
                              historydf = history,
                              exps = list(exp1, exp2))

}
