% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smr_major.R
\name{smr_major}
\alias{smr_major}
\title{Calculate SMRs for Major groupings}
\usage{
smr_major(smr_minor_table, rateobj)
}
\arguments{
\item{smr_minor_table}{A data.frame/tibble as created by \code{smr_minor} containing
observed and expected number of deaths for each minor outcome}

\item{rateobj}{A rate object created by \code{parseRate}}
}
\value{
A data.frame/tibble containing the expected and observed number of deaths
as well as SMRs, lower CI and upper CI for each major as defined in the rate object
\code{rateobj}
}
\description{
\code{smr_major} will collapse minor outcomes into "major" groupings as defined in the
rate object, \code{rateobj}.
}
\examples{
library(LTASR)
library(dplyr)

#Import example person file
person <- person_example \%>\%
  mutate(dob = as.Date(dob, format='\%m/\%d/\%Y'),
         pybegin = as.Date(pybegin, format='\%m/\%d/\%Y'),
         dlo = as.Date(dlo, format='\%m/\%d/\%Y'))

#Import default rate object
rateobj <- us_119ucod_19602020

#Stratify person table
py_table <- get_table(person, rateobj)

#Calculate SMRs for all minors
smr_minor_table <- smr_minor(py_table, rateobj)

#Calculate SMRs major groupings found within rate file
smr_major(smr_minor_table, rateobj)

}
